/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.start.ClassLoaderType;
import java.util.ArrayList;
import java.util.Collection;

public enum XapModules {
    CORE_COMMON("/required/xap-common", ClassLoaderType.SYSTEM),
    DATA_GRID("/required/xap-datagrid", ClassLoaderType.COMMON),
    CORE_REFLECTIONS_ASM("/required/xap-asm", ClassLoaderType.COMMON),
    CORE_COLLECTIONS_TROVE("/required/xap-trove", ClassLoaderType.COMMON),
    LICENSE("/required/xap-premium-common", ClassLoaderType.COMMON),
    MAP("/optional/map/xap-map", ClassLoaderType.COMMON),
    NEAR_CACHE("/optional/near-cache/xap-near-cache", ClassLoaderType.COMMON),
    INTEROP("/optional/interop/xap-interop", ClassLoaderType.COMMON),
    WAN("/optional/wan-gateway/xap-wan-gateway", ClassLoaderType.COMMON),
    SERVICE_GRID("/platform/service-grid/xap-service-grid", ClassLoaderType.COMMON),
    HIBERNATE_SPRING("/optional/hibernate/xap-hibernate-spring", ClassLoaderType.SERVICE),
    JPA_SPRING("/optional/jpa/xap-jpa-spring", ClassLoaderType.SERVICE),
    MAP_SPRING("/optional/map/xap-map-spring", ClassLoaderType.SERVICE),
    NEAR_CACHE_SPRING("/optional/near-cache/xap-near-cache-spring", ClassLoaderType.SERVICE),
    INTEROP_SPRING("/optional/interop/xap-interop-spring", ClassLoaderType.SERVICE),
    WAN_SPRING("/optional/wan-gateway/xap-wan-gateway-spring", ClassLoaderType.SERVICE),
    ADMIN("/platform/service-grid/xap-admin", ClassLoaderType.SERVICE);

    private static final Collection<XapModules> REQUIRED_NON_SERVICE_CL_MODULES;
    private final String artifactName;
    private final String jarFileName;
    private final String jarFilePath;
    private final ClassLoaderType classLoaderType;

    private static Collection<XapModules> initRequiredNonServiceModules() {
        ArrayList<XapModules> result = new ArrayList<XapModules>();
        for (XapModules module : XapModules.values()) {
            if (module.getClassLoaderType() == ClassLoaderType.SERVICE || !module.getJarFilePath().startsWith("/required/")) continue;
            result.add(module);
        }
        return result;
    }

    public static Collection<XapModules> getByClassLoaderType(ClassLoaderType classLoaderType) {
        ArrayList<XapModules> result = new ArrayList<XapModules>();
        for (XapModules module : XapModules.values()) {
            if (!module.getClassLoaderType().equals((Object)classLoaderType)) continue;
            result.add(module);
        }
        return result;
    }

    private XapModules(String path, ClassLoaderType classLoaderType) {
        this.classLoaderType = classLoaderType;
        int pos = path.lastIndexOf(47);
        this.artifactName = pos == -1 ? path : path.substring(pos + 1);
        this.jarFileName = this.artifactName + ".jar";
        this.jarFilePath = path + ".jar";
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public ClassLoaderType getClassLoaderType() {
        return this.classLoaderType;
    }

    public static boolean isRequiredCommonOrBoot(String filename) {
        for (XapModules module : REQUIRED_NON_SERVICE_CL_MODULES) {
            if (!filename.startsWith(module.artifactName)) continue;
            return true;
        }
        return false;
    }

    static {
        REQUIRED_NON_SERVICE_CL_MODULES = XapModules.initRequiredNonServiceModules();
    }
}

