/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jini.rio.boot.BootUtil;

public class XapNetworkInfo {
    private static volatile XapNetworkInfo instance;
    private final String hostId;
    private final InetAddress host;
    private final InetAddress publicHost;
    private String publicHostId;
    private boolean publicHostConfigured;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XapNetworkInfo getInstance() {
        XapNetworkInfo snapshot = instance;
        if (snapshot != null) {
            return snapshot;
        }
        Class<XapNetworkInfo> clazz = XapNetworkInfo.class;
        synchronized (XapNetworkInfo.class) {
            if (instance == null) {
                instance = new XapNetworkInfo();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private XapNetworkInfo() {
        try {
            this.hostId = BootUtil.getHostAddress();
            this.host = InetAddress.getByName(this.hostId);
            this.publicHostId = System.getenv("XAP_PUBLIC_HOST");
            if (this.publicHostId == null) {
                this.publicHostId = this.hostId;
                this.publicHost = this.host;
            } else {
                this.publicHostConfigured = true;
                this.publicHost = InetAddress.getByName(this.publicHostId);
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Failed to get network information", e);
        }
    }

    public String getHostId() {
        return this.hostId;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public String getPublicHostId() {
        return this.publicHostId;
    }

    public InetAddress getPublicHost() {
        return this.publicHost;
    }

    public boolean isPublicHostConfigured() {
        return this.publicHostConfigured;
    }
}

