/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start.manager;

import com.gigaspaces.start.manager.XapManagerConfig;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XapManagerClusterInfo {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.manager");
    public static final String SERVERS_PROPERTY = "com.gs.manager.servers";
    public static final String SERVER_PROPERTY = "com.gs.manager.server";
    public static final String SERVERS_ENV_VAR = "XAP_MANAGER_SERVERS";
    public static final String SERVER_ENV_VAR = "XAP_MANAGER_SERVER";
    private final XapManagerConfig currServer;
    private final XapManagerConfig[] servers;

    public XapManagerClusterInfo(InetAddress currHost) {
        this(XapManagerClusterInfo.parse(), currHost);
    }

    public XapManagerClusterInfo(String host, InetAddress currHost) {
        this(Collections.singletonList(XapManagerConfig.parse(host)), currHost);
    }

    private XapManagerClusterInfo(Collection<XapManagerConfig> servers, InetAddress currHost) {
        if (servers.size() != 0 && servers.size() != 1 && servers.size() != 3) {
            throw new UnsupportedOperationException("Unsupported xap manager cluster size: " + servers.size());
        }
        this.servers = servers.toArray(new XapManagerConfig[servers.size()]);
        this.currServer = this.findManagerByHost(currHost);
        if (this.currServer != null) {
            System.setProperty("com.gs.manager.rest.url", this.currServer.getAdminRestUrl());
        }
    }

    public XapManagerConfig[] getServers() {
        return this.servers;
    }

    public boolean isEmpty() {
        return this.servers.length == 0;
    }

    public XapManagerConfig getCurrServer() {
        return this.currServer;
    }

    public String toString() {
        return Arrays.toString(this.servers);
    }

    private static Collection<XapManagerConfig> parse() {
        Collection<XapManagerConfig> shortList = XapManagerClusterInfo.parseShort();
        Collection<XapManagerConfig> fullList = XapManagerClusterInfo.parseFull();
        if (shortList.size() != 0 && fullList.size() != 0) {
            throw new IllegalStateException("Ambiguous XAP manager cluster configuration (short and full)");
        }
        return shortList.size() != 0 ? shortList : fullList;
    }

    private static Collection<XapManagerConfig> parseShort() {
        String var = XapManagerClusterInfo.get(SERVERS_PROPERTY, SERVERS_ENV_VAR);
        return XapManagerClusterInfo.parseServersEnvVar(var);
    }

    public static Collection<XapManagerConfig> parseServersEnvVar(String serversEnvVar) {
        ArrayList<XapManagerConfig> result = new ArrayList<XapManagerConfig>();
        if (serversEnvVar != null && !serversEnvVar.isEmpty()) {
            String[] tokens;
            for (String token : tokens = serversEnvVar.split(",")) {
                result.add(XapManagerConfig.parse(token));
            }
        }
        return result;
    }

    private static Collection<XapManagerConfig> parseFull() {
        String var;
        ArrayList<XapManagerConfig> result = new ArrayList<XapManagerConfig>();
        for (int i = 1; i < 10 && (var = XapManagerClusterInfo.get("com.gs.manager.server." + i, "XAP_MANAGER_SERVER_" + i)) != null && var.length() != 0; ++i) {
            result.add(XapManagerClusterInfo.parse(var));
        }
        return result;
    }

    private static XapManagerConfig parse(String s) {
        XapManagerConfig result = XapManagerConfig.parse(s);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Parse XapManagerConfig " + result);
        }
        return result;
    }

    private static String get(String sysProp, String envVar) {
        String result = System.getProperty(sysProp);
        if (result != null) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Loaded config from system property " + sysProp + "=" + result);
            }
            return result;
        }
        result = System.getenv(envVar);
        if (result != null) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Loaded config from environment variable " + envVar + "=" + result);
            }
            return result;
        }
        return null;
    }

    private XapManagerConfig findManagerByHost(InetAddress currHost) {
        XapManagerConfig result = null;
        for (XapManagerConfig server : this.servers) {
            if (!server.getHost().equals(currHost.getHostName()) && !server.getHost().equals(currHost.getHostAddress())) continue;
            result = server;
        }
        if (result == null && this.servers.length == 1 && (this.servers[0].getHost().equals("localhost") || this.servers[0].getHost().equals("127.0.0.1"))) {
            result = this.servers[0];
        }
        if (logger.isLoggable(Level.CONFIG)) {
            if (result == null) {
                logger.log(Level.CONFIG, "Current host [" + currHost + "] is not part of configured managers");
            } else {
                logger.log(Level.CONFIG, "Current manager is " + result);
            }
        }
        return result;
    }
}

