/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start.manager;

import java.util.Map;
import java.util.Properties;

public class XapManagerConfig {
    private final String host;
    private final Properties properties;
    private static final String DEFAULT_REST = System.getProperty("com.gs.manager.rest.port", "8090");
    private static final boolean SSL_ENABLED = Boolean.getBoolean("com.gs.manager.rest.ssl.enabled");

    public XapManagerConfig(String host) {
        this(host, new Properties());
    }

    public XapManagerConfig(String host, Properties properties) {
        this.host = host;
        this.properties = properties;
    }

    public static XapManagerConfig parse(String s) {
        String[] tokens = s.split(";");
        String host = tokens[0];
        Properties properties = new Properties();
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i];
            int pos = token.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException("Invalid manager config '" + s + "' - element '" + token + "' does not contain '='");
            }
            String key = token.substring(0, pos);
            String value = token.substring(pos + 1);
            properties.setProperty(key, value);
        }
        return new XapManagerConfig(host, properties);
    }

    public String getHost() {
        return this.host;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getZookeeper() {
        return this.properties.getProperty("zookeeper");
    }

    public String getLookupService() {
        return this.properties.getProperty("lus");
    }

    public String getAdminRest() {
        return this.properties.getProperty("rest", DEFAULT_REST);
    }

    public String getAdminRestUrl() {
        return this.getAdminRestUrl(this.getAdminRest());
    }

    public String getAdminRestUrl(String port) {
        return (SSL_ENABLED ? "https" : "http") + "://" + this.getHost() + ":" + port;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String toString() {
        String result = this.host;
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            result = result + ";" + entry.getKey() + "=" + entry.getValue();
        }
        return result;
    }
}

