/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.time;

import com.gigaspaces.time.ITimeProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Perf;

public final class RelativeTime
implements ITimeProvider {
    final Perf _perf = AccessController.doPrivileged(new PrivilegedAction<Perf>(){

        @Override
        public Perf run() {
            return Perf.getPerf();
        }
    });
    final long TICKS_PER_SECOND;
    static final long TO_MILLISECONDS = 1000L;

    public RelativeTime() {
        if (this._perf == null) {
            throw new RuntimeException("Limitation - unable to load sun.misc.Perf provider; \n\t The undocumented sun.misc.Perf class provides high resolution access to the system clock. @since Sun JDK1.4.2\n");
        }
        if (!System.getProperty("file.separator").equals("\\")) {
            throw new RuntimeException("Limitation - Relative Time is currently limited to Windows OS.");
        }
        this.TICKS_PER_SECOND = this._perf.highResFrequency();
    }

    @Override
    public long timeMillis() {
        return this._perf.highResCounter() * 1000L / this.TICKS_PER_SECOND;
    }

    @Override
    public boolean isRelative() {
        return true;
    }
}

