/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.action;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

@InternalApi
public class GetBooleanAction
implements PrivilegedAction {
    private static final Logger logger = Logger.getLogger("com.sun.jini.action.GetBooleanAction");
    private final String theProp;

    public GetBooleanAction(String theProp) {
        this.theProp = theProp;
    }

    public Object run() {
        try {
            return Boolean.getBoolean(this.theProp) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (SecurityException e) {
            if (logger.isLoggable(Levels.HANDLED)) {
                LogUtil.logThrow(logger, Levels.HANDLED, GetBooleanAction.class, "run", "security exception reading \"{0}\", returning false", new Object[]{this.theProp}, e);
            }
            return Boolean.FALSE;
        }
    }
}

