/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.action;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

@InternalApi
public class GetLongAction
implements PrivilegedAction {
    private static final Logger logger = Logger.getLogger("com.sun.jini.action.GetLongAction");
    private final String theProp;
    private final long defaultVal;
    private final boolean defaultSet;

    public GetLongAction(String theProp) {
        this.theProp = theProp;
        this.defaultVal = 0L;
        this.defaultSet = false;
    }

    public GetLongAction(String theProp, long defaultVal) {
        this.theProp = theProp;
        this.defaultVal = defaultVal;
        this.defaultSet = true;
    }

    public Object run() {
        block3: {
            try {
                Long value = Long.getLong(this.theProp);
                if (value != null) {
                    return value;
                }
            }
            catch (SecurityException e) {
                if (!logger.isLoggable(Levels.HANDLED)) break block3;
                LogUtil.logThrow(logger, Levels.HANDLED, GetLongAction.class, "run", "security exception reading \"{0}\", returning {1}", new Object[]{this.theProp, this.defaultValue()}, e);
            }
        }
        return this.defaultValue();
    }

    private Long defaultValue() {
        return this.defaultSet ? new Long(this.defaultVal) : null;
    }
}

