/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.action;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

@InternalApi
public class GetPropertyAction
implements PrivilegedAction {
    private static final Logger logger = Logger.getLogger("com.sun.jini.action.GetPropertyAction");
    private final String theProp;
    private final String defaultVal;

    public GetPropertyAction(String theProp) {
        this.theProp = theProp;
        this.defaultVal = null;
    }

    public GetPropertyAction(String theProp, String defaultVal) {
        this.theProp = theProp;
        this.defaultVal = defaultVal;
    }

    public Object run() {
        block3: {
            try {
                String value = System.getProperty(this.theProp);
                if (value != null) {
                    return value;
                }
            }
            catch (SecurityException e) {
                if (!logger.isLoggable(Levels.HANDLED)) break block3;
                LogUtil.logThrow(logger, Levels.HANDLED, GetPropertyAction.class, "run", "security exception reading \"{0}\", returning {1}", new Object[]{this.theProp, this.defaultVal}, e);
            }
        }
        return this.defaultVal;
    }
}

