/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.discovery.DiscoveryProtocolVersion;
import com.sun.jini.discovery.MulticastMaxPacketSize;
import com.sun.jini.discovery.MulticastTimeToLive;
import com.sun.jini.discovery.UnicastSocketTimeout;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConnectionRelativeTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

@InternalApi
public class DiscoveryConstraints {
    public static final Method multicastRequestMethod;
    public static final Method multicastAnnouncementMethod;
    public static final Method unicastDiscoveryMethod;
    private static final Set supportedProtocols;
    private final InvocationConstraints unfulfilled;
    private final Set protocolVersions;
    private final int preferredProtocolVersion;
    private final ConnectionAbsoluteTime connectionAbsoluteTime;
    private final MulticastMaxPacketSize maxPacketSize;
    private final MulticastTimeToLive timeToLive;
    private final UnicastSocketTimeout socketTimeout;

    public static void multicastRequest() {
    }

    public static void multicastAnnouncement() {
    }

    public static void unicastDiscovery() {
    }

    public static DiscoveryConstraints process(InvocationConstraints constraints) throws UnsupportedConstraintException {
        return new DiscoveryConstraints(constraints);
    }

    private DiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        this.unfulfilled = new InvocationConstraints(DiscoveryConstraints.getUnfulfilled(constraints.requirements()), DiscoveryConstraints.getUnfulfilled(constraints.preferences()));
        ConstraintReducer cr = new ConstraintReducer(DiscoveryProtocolVersion.class);
        this.protocolVersions = cr.reduce(new InvocationConstraints(constraints.requirements(), null));
        if (!this.protocolVersions.isEmpty() && DiscoveryConstraints.intersect(this.protocolVersions, supportedProtocols).isEmpty()) {
            throw new UnsupportedConstraintException("no supported protocols: " + this.protocolVersions);
        }
        this.preferredProtocolVersion = DiscoveryConstraints.chooseProtocolVersion(this.protocolVersions, cr.reduce(constraints), this.unfulfilled);
        Set s = new MulticastMaxPacketSizeReducer().reduce(constraints);
        this.maxPacketSize = s.isEmpty() ? null : (MulticastMaxPacketSize)DiscoveryConstraints.getElement(s);
        s = new ConstraintReducer(MulticastTimeToLive.class).reduce(constraints);
        this.timeToLive = s.isEmpty() ? null : (MulticastTimeToLive)DiscoveryConstraints.getElement(s);
        s = new ConstraintReducer(UnicastSocketTimeout.class).reduce(constraints);
        this.socketTimeout = s.isEmpty() ? null : (UnicastSocketTimeout)DiscoveryConstraints.getElement(s);
        InvocationConstraints absConstraints = new InvocationConstraints(constraints.requirements(), constraints.preferences()).makeAbsolute();
        s = new ConnectionAbsoluteTimeReducer().reduce(absConstraints);
        this.connectionAbsoluteTime = s.isEmpty() ? null : (ConnectionAbsoluteTime)DiscoveryConstraints.getElement(s);
    }

    public int chooseProtocolVersion() {
        return this.preferredProtocolVersion;
    }

    public void checkProtocolVersion(int version) throws UnsupportedConstraintException {
        if (!this.protocolVersions.isEmpty() && !this.protocolVersions.contains(DiscoveryProtocolVersion.getInstance(version))) {
            throw new UnsupportedConstraintException("disallowed protocol: " + version);
        }
    }

    public long getConnectionDeadline(long defaultValue) {
        return this.connectionAbsoluteTime != null ? this.connectionAbsoluteTime.getTime() : defaultValue;
    }

    public int getMulticastMaxPacketSize(int defaultValue) {
        return this.maxPacketSize != null ? this.maxPacketSize.getSize() : defaultValue;
    }

    public int getMulticastTimeToLive(int defaultValue) {
        return this.timeToLive != null ? this.timeToLive.getTimeToLive() : defaultValue;
    }

    public int getUnicastSocketTimeout(int defaultValue) {
        return this.socketTimeout != null ? this.socketTimeout.getTimeout() : defaultValue;
    }

    public InvocationConstraints getUnfulfilledConstraints() {
        return this.unfulfilled;
    }

    private static Set getUnfulfilled(Set constraints) {
        HashSet<InvocationConstraint> unfulfilled = new HashSet<InvocationConstraint>(constraints.size());
        for (InvocationConstraint c : constraints) {
            if (c instanceof ConstraintAlternatives) {
                Set s = ((ConstraintAlternatives)c).elements();
                Set u = DiscoveryConstraints.getUnfulfilled(s);
                if (u.size() != s.size()) continue;
                unfulfilled.add(c);
                continue;
            }
            if (c instanceof DiscoveryProtocolVersion || c instanceof MulticastMaxPacketSize || c instanceof MulticastTimeToLive || c instanceof UnicastSocketTimeout || c instanceof ConnectionAbsoluteTime || c instanceof ConnectionRelativeTime) continue;
            unfulfilled.add(c);
        }
        return unfulfilled;
    }

    private static int chooseProtocolVersion(Set protocolVersions, Set protocolVersionPrefs, InvocationConstraints unfulfilled) {
        DiscoveryProtocolVersion bias = unfulfilled.isEmpty() ? DiscoveryProtocolVersion.ONE : DiscoveryProtocolVersion.TWO;
        Set[] sets = new Set[]{protocolVersionPrefs, protocolVersions};
        for (int i = 0; i < sets.length; ++i) {
            Set s = sets[i];
            if (s.contains(bias)) {
                return bias.getVersion();
            }
            if ((s = DiscoveryConstraints.intersect(s, supportedProtocols)).isEmpty()) continue;
            return ((DiscoveryProtocolVersion)DiscoveryConstraints.getElement(s)).getVersion();
        }
        return bias.getVersion();
    }

    private static Set intersect(Set s1, Set s2) {
        HashSet intersection = Collections.EMPTY_SET;
        for (Object obj : s1) {
            if (!s2.contains(obj)) continue;
            if (intersection.isEmpty()) {
                intersection = new HashSet();
            }
            intersection.add(obj);
        }
        return intersection;
    }

    private static Object getElement(Set s) {
        return s.iterator().next();
    }

    static {
        try {
            multicastRequestMethod = DiscoveryConstraints.class.getMethod("multicastRequest", null);
            multicastAnnouncementMethod = DiscoveryConstraints.class.getMethod("multicastAnnouncement", null);
            unicastDiscoveryMethod = DiscoveryConstraints.class.getMethod("unicastDiscovery", null);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        supportedProtocols = new HashSet(2);
        supportedProtocols.add(DiscoveryProtocolVersion.ONE);
        supportedProtocols.add(DiscoveryProtocolVersion.TWO);
    }

    private static class ConnectionAbsoluteTimeReducer
    extends MaxValueReducer {
        ConnectionAbsoluteTimeReducer() {
            super(ConnectionAbsoluteTime.class);
        }

        @Override
        long getValue(InvocationConstraint absTime) {
            return ((ConnectionAbsoluteTime)absTime).getTime();
        }

        @Override
        InvocationConstraint getConstraintInstance(long value) {
            return new ConnectionAbsoluteTime(value);
        }
    }

    private static class MulticastMaxPacketSizeReducer
    extends MaxValueReducer {
        MulticastMaxPacketSizeReducer() {
            super(MulticastMaxPacketSize.class);
        }

        @Override
        long getValue(InvocationConstraint maxPacketSize) {
            return ((MulticastMaxPacketSize)maxPacketSize).getSize();
        }

        @Override
        InvocationConstraint getConstraintInstance(long value) {
            if (value > Integer.MAX_VALUE) {
                throw new AssertionError((Object)("Value too large " + value));
            }
            return new MulticastMaxPacketSize((int)value);
        }
    }

    private static abstract class MaxValueReducer
    extends ConstraintReducer {
        MaxValueReducer(Class targetClass) {
            super(targetClass);
        }

        abstract long getValue(InvocationConstraint var1);

        abstract InvocationConstraint getConstraintInstance(long var1);

        @Override
        Set reduce0(Set reduced, Set toReduce) {
            long value = 0L;
            Iterator i = toReduce.iterator();
            while (i.hasNext()) {
                value = Math.max(value, this.getValue((InvocationConstraint)i.next()));
            }
            if (reduced != null) {
                value = Math.min(value, this.getValue((InvocationConstraint)DiscoveryConstraints.getElement(reduced)));
            }
            return Collections.singleton(this.getConstraintInstance(value));
        }
    }

    private static class ConstraintReducer {
        private final Class targetClass;

        ConstraintReducer(Class targetClass) {
            this.targetClass = targetClass;
        }

        Set reduce(InvocationConstraints constraints) throws UnsupportedConstraintException {
            Set reduced = this.reduce(null, constraints.requirements(), true);
            return (reduced = this.reduce(reduced, constraints.preferences(), false)) != null ? reduced : Collections.EMPTY_SET;
        }

        Set reduce0(Set reduced, Set toReduce) {
            return reduced != null ? DiscoveryConstraints.intersect(reduced, toReduce) : toReduce;
        }

        private Set reduce(Set reduced, Set constraints, boolean required) throws UnsupportedConstraintException {
            for (InvocationConstraint c : constraints) {
                Set toReduce = Collections.EMPTY_SET;
                if (this.targetClass.isInstance(c)) {
                    toReduce = Collections.singleton(c);
                } else if (c instanceof ConstraintAlternatives) {
                    toReduce = this.getTargetInstances(((ConstraintAlternatives)c).elements());
                }
                if (toReduce.isEmpty()) continue;
                Set s = this.reduce0(reduced, toReduce);
                if (!s.isEmpty()) {
                    reduced = s;
                    continue;
                }
                if (!required) continue;
                throw new UnsupportedConstraintException("constraints conflict: " + constraints);
            }
            return reduced;
        }

        private Set getTargetInstances(Set set) {
            HashSet instances = Collections.EMPTY_SET;
            for (Object obj : set) {
                if (!this.targetClass.isInstance(obj)) continue;
                if (instances.isEmpty()) {
                    instances = new HashSet();
                }
                instances.add(obj);
            }
            return instances;
        }
    }
}

