/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.Plaintext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.Constants;
import net.jini.io.MarshalInputStream;
import net.jini.io.OptimizedByteArrayInputStream;
import net.jini.io.UnsupportedConstraintException;

class DiscoveryV1
extends Discovery {
    private static final int SERVICE_ID_LEN = 16;
    private static final byte REQUEST_TYPE = 1;
    private static final byte ANNOUNCEMENT_TYPE = 2;
    private static final DiscoveryV1 instance = new DiscoveryV1();
    private static final Logger logger = Logger.getLogger(DiscoveryV1.class.getName());

    DiscoveryV1() {
    }

    static DiscoveryV1 getInstance() {
        return instance;
    }

    @Override
    public EncodeIterator encodeMulticastRequest(final MulticastRequest request, final int maxPacketSize, final InvocationConstraints constraints) {
        if (maxPacketSize < 512) {
            throw new IllegalArgumentException("maxPacketSize too small");
        }
        return new EncodeIterator(){
            private boolean used;

            @Override
            public DatagramPacket[] next() throws IOException {
                this.used = true;
                return DiscoveryV1.encode(request, maxPacketSize, constraints);
            }

            @Override
            public boolean hasNext() {
                return !this.used;
            }
        };
    }

    private static DatagramPacket[] encode(MulticastRequest request, int maxPacketSize, InvocationConstraints constraints) throws IOException {
        int MIN_DATA_LEN = 16;
        int NUM_GROUPS_LEN = 4;
        int NUM_SERVICE_IDS_LEN = 4;
        DiscoveryV1.checkConstraints(constraints);
        LinkedList<byte[]> groups = new LinkedList<byte[]>();
        byte[] host = Plaintext.toUtf(request.getHost());
        String[] g = request.getGroups();
        for (int i = 0; i < g.length; ++i) {
            byte[] b = Plaintext.toUtf(g[i]);
            if (b.length + host.length + 16 > maxPacketSize) {
                throw new DiscoveryProtocolException("group too long: " + g[i]);
            }
            groups.add(b);
        }
        ArrayList<DatagramPacket> packets = new ArrayList<DatagramPacket>();
        do {
            ByteBuffer buf = ByteBuffer.allocate(maxPacketSize);
            buf.putInt(1);
            buf.put((byte)1);
            buf.putInt(request.getPort());
            ServiceID[] ids = request.getServiceIDs();
            int nids = Math.min(ids.length, (buf.remaining() - (groups.isEmpty() ? 0 : ((byte[])groups.getFirst()).length) - 4 - 4) / 16);
            buf.putInt(nids);
            for (int i = 0; i < nids; ++i) {
                buf.putLong(ids[i].getMostSignificantBits());
                buf.putLong(ids[i].getLeastSignificantBits());
            }
            int ngroupsPos = buf.position();
            int ngroups = 0;
            buf.putInt(ngroups);
            while (!groups.isEmpty() && ((byte[])groups.getFirst()).length <= buf.remaining()) {
                buf.put((byte[])groups.removeFirst());
                ++ngroups;
            }
            if (ngroups > 0) {
                buf.putInt(ngroupsPos, ngroups);
            }
            buf.put(host);
            packets.add(new DatagramPacket(buf.array(), buf.position(), Constants.getRequestAddress(), Constants.getDiscoveryPort()));
        } while (!groups.isEmpty());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "encoded {0}", new Object[]{request});
        }
        return packets.toArray(new DatagramPacket[packets.size()]);
    }

    @Override
    public MulticastRequest decodeMulticastRequest(DatagramPacket packet, InvocationConstraints constraints, ClientSubjectChecker checker) throws IOException {
        DiscoveryV1.checkConstraints(constraints);
        if (checker != null) {
            checker.checkClientSubject(null);
        }
        try {
            ByteBuffer buf = ByteBuffer.wrap(packet.getData(), packet.getOffset(), packet.getLength());
            int version = buf.getInt();
            if (version != 1) {
                throw new DiscoveryProtocolException("wrong protocol version: " + version);
            }
            byte type = buf.get();
            if (type != 1) {
                throw new DiscoveryProtocolException("invalid type (we might get this when announcement and request are running on different address but using the same port (os bug)): " + type);
            }
            String host = packet.getAddress().getHostAddress();
            int port = buf.getInt();
            int nids = buf.getInt();
            if (nids < 0 || nids > buf.remaining() / 16) {
                throw new DiscoveryProtocolException("invalid service ID count: " + nids);
            }
            ServiceID[] ids = new ServiceID[nids];
            for (int i = 0; i < ids.length; ++i) {
                long hi = buf.getLong();
                long lo = buf.getLong();
                ids[i] = new ServiceID(hi, lo);
            }
            int ngroups = buf.getInt();
            if (ngroups < 0 || ngroups > buf.remaining() / 2) {
                throw new DiscoveryProtocolException("invalid group count: " + ngroups);
            }
            String[] groups = new String[ngroups];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = Plaintext.getUtf(buf);
            }
            try {
                host = Plaintext.getUtf(buf);
            }
            catch (Exception i) {
                // empty catch block
            }
            MulticastRequest req = new MulticastRequest(host, port, groups, ids);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "decoded {0}", new Object[]{req});
            }
            return req;
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    @Override
    public EncodeIterator encodeMulticastAnnouncement(final MulticastAnnouncement announcement, final int maxPacketSize, final InvocationConstraints constraints) {
        if (maxPacketSize < 512) {
            throw new IllegalArgumentException("maxPacketSize too small");
        }
        return new EncodeIterator(){
            private boolean used;

            @Override
            public DatagramPacket[] next() throws IOException {
                this.used = true;
                return DiscoveryV1.encode(announcement, maxPacketSize, constraints);
            }

            @Override
            public boolean hasNext() {
                return !this.used;
            }
        };
    }

    private static DatagramPacket[] encode(MulticastAnnouncement announcement, int maxPacketSize, InvocationConstraints constraints) throws IOException {
        int MIN_DATA_LEN = 28;
        DiscoveryV1.checkConstraints(constraints);
        LinkedList<byte[]> groups = new LinkedList<byte[]>();
        byte[] host = Plaintext.toUtf(announcement.getHost());
        String[] g = announcement.getGroups();
        for (int i = 0; i < g.length; ++i) {
            byte[] b = Plaintext.toUtf(g[i]);
            if (b.length + host.length + 28 > maxPacketSize) {
                throw new DiscoveryProtocolException("group too long: " + g[i]);
            }
            groups.add(b);
        }
        ArrayList<DatagramPacket> packets = new ArrayList<DatagramPacket>();
        do {
            ByteBuffer buf = ByteBuffer.allocate(maxPacketSize);
            buf.putInt(1);
            buf.put((byte)2);
            buf.put(host);
            buf.putInt(announcement.getPort());
            ServiceID id = announcement.getServiceID();
            buf.putLong(id.getMostSignificantBits());
            buf.putLong(id.getLeastSignificantBits());
            int ngroupsPos = buf.position();
            int ngroups = 0;
            buf.putInt(ngroups);
            while (!groups.isEmpty() && ((byte[])groups.getFirst()).length <= buf.remaining()) {
                buf.put((byte[])groups.removeFirst());
                ++ngroups;
            }
            if (ngroups > 0) {
                buf.putInt(ngroupsPos, ngroups);
            }
            packets.add(new DatagramPacket(buf.array(), buf.position(), Constants.getAnnouncementAddress(), Constants.getDiscoveryPort()));
        } while (!groups.isEmpty());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "encoded {0}", new Object[]{announcement});
        }
        return packets.toArray(new DatagramPacket[packets.size()]);
    }

    @Override
    public MulticastAnnouncement decodeMulticastAnnouncement(DatagramPacket packet, InvocationConstraints constraints) throws IOException {
        DiscoveryV1.checkConstraints(constraints);
        try {
            ByteBuffer buf = ByteBuffer.wrap(packet.getData(), packet.getOffset(), packet.getLength());
            int version = buf.getInt();
            if (version != 1) {
                throw new DiscoveryProtocolException("wrong protocol version: " + version);
            }
            byte type = buf.get();
            if (type != 2) {
                throw new DiscoveryProtocolException("invalid type (we might get this when announcement and request are running on different address but using the same port (os bug)): " + type);
            }
            String host = Plaintext.getUtf(buf);
            int port = buf.getInt();
            long hi = buf.getLong();
            long lo = buf.getLong();
            ServiceID id = new ServiceID(hi, lo);
            int ngroups = buf.getInt();
            if (ngroups < 0 || ngroups > buf.remaining() / 2) {
                throw new DiscoveryProtocolException("invalid group count: " + ngroups);
            }
            String[] groups = new String[ngroups];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = Plaintext.getUtf(buf);
            }
            MulticastAnnouncement ann = new MulticastAnnouncement(-1L, host, port, groups, id);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "decoded {0}", new Object[]{ann});
            }
            return ann;
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    @Override
    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints constraints, ClassLoader defaultLoader, ClassLoader verifierLoader, Collection context) throws IOException, ClassNotFoundException {
        DiscoveryV1.checkConstraints(constraints);
        try {
            DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 4));
            dout.writeInt(1);
            dout.flush();
            String host = socket.getInetAddress().getHostAddress();
            int port = socket.getPort();
            ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            byte[] registrarBytes = new byte[oin.readInt()];
            oin.readFully(registrarBytes);
            int ngroups = oin.readInt();
            if (ngroups < 0) {
                throw new DiscoveryProtocolException("invalid group count: " + ngroups);
            }
            String[] groups = new String[ngroups];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = oin.readUTF();
            }
            socket.close();
            if (context == null) {
                context = Collections.EMPTY_SET;
            }
            MarshalInputStream os = new MarshalInputStream(new OptimizedByteArrayInputStream(registrarBytes), defaultLoader, false, null, context);
            ServiceRegistrar reg = (ServiceRegistrar)os.readObject();
            UnicastResponse resp = new UnicastResponse(host, port, groups, reg);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "received {0}", new Object[]{resp});
            }
            return resp;
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    @Override
    public void handleUnicastDiscovery(UnicastResponse response, Socket socket, InvocationConstraints constraints, ClientSubjectChecker checker, Collection context) throws IOException {
        DiscoveryV1.checkConstraints(constraints);
        if (checker != null) {
            checker.checkClientSubject(null);
        }
        ObjectOutputStream oout = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        oout.writeInt(response.getRegistrarBytes().length);
        oout.write(response.getRegistrarBytes());
        String[] groups = response.getGroups();
        oout.writeInt(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            oout.writeUTF(groups[i]);
        }
        oout.flush();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "sent {0}", new Object[]{response});
        }
    }

    public String toString() {
        return "DiscoveryV1";
    }

    private static void checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        if (constraints != null) {
            constraints = constraints.makeAbsolute();
        }
        Plaintext.checkConstraints(constraints);
    }
}

