/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.sun.jini.collection.WeakIdentityMap;
import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.DelayedMulticastAnnouncementDecoder;
import com.sun.jini.discovery.DelayedMulticastRequestDecoder;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryFormatProvider;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementDecoder;
import com.sun.jini.discovery.MulticastAnnouncementEncoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestDecoder;
import com.sun.jini.discovery.MulticastRequestEncoder;
import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastDiscoveryServer;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.logging.Levels;
import com.sun.jini.resource.Service;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.discovery.Constants;
import net.jini.io.UnsupportedConstraintException;

class DiscoveryV2
extends Discovery {
    private static final byte MULTICAST_ANNOUNCEMENT = 0;
    private static final byte MULTICAST_REQUEST = 1;
    private static final long NULL_FORMAT_ID = 0L;
    private static final int FORMAT_ID_LEN = 8;
    private static final int MULTICAST_HEADER_LEN = 13;
    private static final int UNICAST_REQUEST_HEADER_LEN = 6;
    private static final int UNICAST_RESPONSE_HEADER_LEN = 12;
    private static final int MULTICAST_REQUEST_ENCODER = 0;
    private static final int MULTICAST_REQUEST_DECODER = 1;
    private static final int MULTICAST_ANNOUNCEMENT_ENCODER = 2;
    private static final int MULTICAST_ANNOUNCEMENT_DECODER = 3;
    private static final int UNICAST_DISCOVERY_CLIENT = 4;
    private static final int UNICAST_DISCOVERY_SERVER = 5;
    private static final int NUM_PROVIDER_TYPES = 6;
    private static final Class[] providerTypes;
    private static final WeakIdentityMap instances;
    private static final Logger logger;
    private final Map[] formatIdMaps = new Map[6];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DiscoveryV2 getInstance(ClassLoader loader) {
        DiscoveryV2 disco;
        if (loader == null) {
            loader = DiscoveryV2.getContextClassLoader();
        }
        WeakIdentityMap weakIdentityMap = instances;
        synchronized (weakIdentityMap) {
            disco = null;
            Reference softDisco = (Reference)instances.get(loader);
            if (softDisco != null) {
                disco = (DiscoveryV2)softDisco.get();
            }
        }
        if (disco == null) {
            disco = new DiscoveryV2(DiscoveryV2.getProviders(loader));
            weakIdentityMap = instances;
            synchronized (weakIdentityMap) {
                instances.put(loader, new SoftReference<DiscoveryV2>(disco));
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "returning {0}", new Object[]{disco});
        }
        return disco;
    }

    static DiscoveryV2 getInstance(MulticastRequestEncoder[] mre, MulticastRequestDecoder[] mrd, MulticastAnnouncementEncoder[] mae, MulticastAnnouncementDecoder[] mad, UnicastDiscoveryClient[] udc, UnicastDiscoveryServer[] uds) {
        List[] providers = new List[]{DiscoveryV2.asList(mre), DiscoveryV2.asList(mrd), DiscoveryV2.asList(mae), DiscoveryV2.asList(mad), DiscoveryV2.asList(udc), DiscoveryV2.asList(uds)};
        DiscoveryV2 disco = new DiscoveryV2(providers);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "returning {0}", new Object[]{disco});
        }
        return disco;
    }

    private DiscoveryV2(List[] providers) {
        for (int i = 0; i < this.formatIdMaps.length; ++i) {
            this.formatIdMaps[i] = DiscoveryV2.makeFormatIdMap(providers[i]);
        }
    }

    @Override
    public EncodeIterator encodeMulticastRequest(final MulticastRequest request, final int maxPacketSize, InvocationConstraints constraints) {
        if (maxPacketSize < 512) {
            throw new IllegalArgumentException("maxPacketSize too small");
        }
        final InvocationConstraints absc = constraints != null ? constraints.makeAbsolute() : null;
        return new EncodeIterator(){
            private final Iterator entries;
            {
                this.entries = DiscoveryV2.this.formatIdMaps[0].entrySet().iterator();
            }

            @Override
            public DatagramPacket[] next() throws IOException {
                Map.Entry ent = (Map.Entry)this.entries.next();
                long fid = (Long)ent.getKey();
                MulticastRequestEncoder mre = (MulticastRequestEncoder)ent.getValue();
                DatagramBuffers db = new DatagramBuffers(Constants.getRequestAddress(), maxPacketSize, 1, fid);
                mre.encodeMulticastRequest(request, db, absc);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "encoded {0} using {1}, {2}", new Object[]{request, mre, absc});
                }
                return db.getDatagrams();
            }

            @Override
            public boolean hasNext() {
                return this.entries.hasNext();
            }
        };
    }

    @Override
    public MulticastRequest decodeMulticastRequest(DatagramPacket packet, InvocationConstraints constraints, ClientSubjectChecker checker, boolean delayConstraintCheck) throws IOException {
        MulticastRequest req;
        ByteBuffer buf;
        if (constraints != null) {
            constraints = constraints.makeAbsolute();
        }
        if ((buf = ByteBuffer.wrap(packet.getData(), packet.getOffset(), packet.getLength()).slice()).remaining() < 13) {
            throw new DiscoveryProtocolException("incomplete header");
        }
        int pv = buf.getInt();
        if (pv != 2) {
            throw new DiscoveryProtocolException("wrong protocol version: " + pv);
        }
        byte pt = buf.get();
        if (pt != 1) {
            throw new DiscoveryProtocolException("wrong packet type: " + pt);
        }
        long fid = buf.getLong();
        MulticastRequestDecoder mrd = (MulticastRequestDecoder)this.formatIdMaps[1].get(new Long(fid));
        if (mrd == null) {
            throw new DiscoveryProtocolException("unsupported format ID: " + fid);
        }
        if (mrd instanceof DelayedMulticastRequestDecoder) {
            DelayedMulticastRequestDecoder dmrd = (DelayedMulticastRequestDecoder)mrd;
            req = dmrd.decodeMulticastRequest(buf, constraints, checker, delayConstraintCheck);
        } else {
            req = mrd.decodeMulticastRequest(buf, constraints, checker);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "decoded {0} using {1}, {2}, {3}", new Object[]{req, mrd, constraints, checker});
        }
        return req;
    }

    @Override
    public MulticastRequest decodeMulticastRequest(DatagramPacket packet, InvocationConstraints constraints, ClientSubjectChecker checker) throws IOException {
        return this.decodeMulticastRequest(packet, constraints, checker, false);
    }

    @Override
    public EncodeIterator encodeMulticastAnnouncement(final MulticastAnnouncement announcement, final int maxPacketSize, InvocationConstraints constraints) {
        if (maxPacketSize < 512) {
            throw new IllegalArgumentException("maxPacketSize too small");
        }
        final InvocationConstraints absc = constraints != null ? constraints.makeAbsolute() : null;
        return new EncodeIterator(){
            private final Iterator entries;
            {
                this.entries = DiscoveryV2.this.formatIdMaps[2].entrySet().iterator();
            }

            @Override
            public DatagramPacket[] next() throws IOException {
                Map.Entry ent = (Map.Entry)this.entries.next();
                long fid = (Long)ent.getKey();
                MulticastAnnouncementEncoder mae = (MulticastAnnouncementEncoder)ent.getValue();
                DatagramBuffers db = new DatagramBuffers(Constants.getAnnouncementAddress(), maxPacketSize, 0, fid);
                mae.encodeMulticastAnnouncement(announcement, db, absc);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "encoded {0} using {1}, {2}", new Object[]{announcement, mae, absc});
                }
                return db.getDatagrams();
            }

            @Override
            public boolean hasNext() {
                return this.entries.hasNext();
            }
        };
    }

    @Override
    public MulticastAnnouncement decodeMulticastAnnouncement(DatagramPacket packet, InvocationConstraints constraints, boolean delayConstraintCheck) throws IOException {
        MulticastAnnouncement ann;
        ByteBuffer buf;
        if (constraints != null) {
            constraints = constraints.makeAbsolute();
        }
        if ((buf = ByteBuffer.wrap(packet.getData(), packet.getOffset(), packet.getLength()).slice()).remaining() < 13) {
            throw new DiscoveryProtocolException("incomplete header");
        }
        int pv = buf.getInt();
        if (pv != 2) {
            throw new DiscoveryProtocolException("wrong protocol version: " + pv);
        }
        byte pt = buf.get();
        if (pt != 0) {
            throw new DiscoveryProtocolException("wrong packet type: " + pt);
        }
        long fid = buf.getLong();
        MulticastAnnouncementDecoder mad = (MulticastAnnouncementDecoder)this.formatIdMaps[3].get(new Long(fid));
        if (mad == null) {
            throw new DiscoveryProtocolException("unsupported format ID: " + fid);
        }
        if (mad instanceof DelayedMulticastAnnouncementDecoder) {
            DelayedMulticastAnnouncementDecoder dmad = (DelayedMulticastAnnouncementDecoder)mad;
            ann = dmad.decodeMulticastAnnouncement(buf, constraints, delayConstraintCheck);
        } else {
            ann = mad.decodeMulticastAnnouncement(buf, constraints);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "decoded {0} using {1}, {2}", new Object[]{ann, mad, constraints});
        }
        return ann;
    }

    @Override
    public MulticastAnnouncement decodeMulticastAnnouncement(DatagramPacket packet, InvocationConstraints constraints) throws IOException {
        return this.decodeMulticastAnnouncement(packet, constraints, false);
    }

    @Override
    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints constraints, ClassLoader defaultLoader, ClassLoader verifierLoader, Collection context) throws IOException, ClassNotFoundException {
        int MAX_FORMATS = 65535;
        if (constraints != null) {
            constraints = constraints.makeAbsolute();
        }
        Map udcMap = this.formatIdMaps[4];
        HashSet fids = new HashSet();
        Exception ex = null;
        for (Map.Entry ent : udcMap.entrySet()) {
            UnicastDiscoveryClient udc = (UnicastDiscoveryClient)ent.getValue();
            try {
                udc.checkUnicastDiscoveryConstraints(constraints);
                fids.add(ent.getKey());
                if (fids.size() != 65535) continue;
                logger.log(Level.WARNING, "truncating format ID list");
                break;
            }
            catch (Exception e) {
                if (e instanceof UnsupportedConstraintException || e instanceof SecurityException) {
                    ex = e;
                    logger.log(Levels.HANDLED, "constraint check failed", e);
                    continue;
                }
                throw (RuntimeException)e;
            }
        }
        if (fids.isEmpty()) {
            if (ex == null) {
                throw new DiscoveryProtocolException("no supported formats");
            }
            if (ex instanceof UnsupportedConstraintException) {
                throw (UnsupportedConstraintException)ex;
            }
            throw (SecurityException)ex;
        }
        ByteBuffer outBuf = ByteBuffer.allocate(6 + 8 * fids.size());
        outBuf.putInt(2);
        outBuf.putShort((short)fids.size());
        Iterator i = fids.iterator();
        while (i.hasNext()) {
            outBuf.putLong((Long)i.next());
        }
        OutputStream out = socket.getOutputStream();
        out.write(outBuf.array(), outBuf.arrayOffset(), outBuf.position());
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(12);
        new DataInputStream(socket.getInputStream()).readFully(inBuf.array(), inBuf.arrayOffset() + inBuf.position(), inBuf.remaining());
        int pv = inBuf.getInt();
        if (pv != 2) {
            throw new DiscoveryProtocolException("wrong protocol version: " + pv);
        }
        Long fid = new Long(inBuf.getLong());
        if (fid == 0L) {
            throw new DiscoveryProtocolException("format negotiation failed");
        }
        if (!fids.contains(fid)) {
            throw new DiscoveryProtocolException("response format ID not proposed: " + fid);
        }
        UnicastDiscoveryClient udc = (UnicastDiscoveryClient)udcMap.get(fid);
        UnicastResponse resp = udc.doUnicastDiscovery(socket, constraints, defaultLoader, verifierLoader, context, (ByteBuffer)outBuf.flip(), (ByteBuffer)inBuf.flip());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "received {0} using {1}, {2}", new Object[]{resp, udc, constraints});
        }
        return resp;
    }

    @Override
    public void handleUnicastDiscovery(UnicastResponse response, Socket socket, InvocationConstraints constraints, ClientSubjectChecker checker, Collection context) throws IOException {
        DataInputStream din;
        int nfids;
        if (constraints != null) {
            constraints = constraints.makeAbsolute();
        }
        if ((nfids = (din = new DataInputStream(socket.getInputStream())).readUnsignedShort()) < 0) {
            throw new DiscoveryProtocolException("invalid format ID count: " + nfids);
        }
        ByteBuffer inBuf = ByteBuffer.allocate(6 + 8 * nfids);
        inBuf.putInt(2);
        inBuf.putShort((short)nfids);
        din.readFully(inBuf.array(), inBuf.arrayOffset() + inBuf.position(), inBuf.remaining());
        UnicastDiscoveryServer uds = null;
        long fid = 0L;
        Map udsMap = this.formatIdMaps[5];
        while (inBuf.hasRemaining()) {
            fid = inBuf.getLong();
            UnicastDiscoveryServer s = (UnicastDiscoveryServer)udsMap.get(new Long(fid));
            if (s == null) continue;
            try {
                s.checkUnicastDiscoveryConstraints(constraints);
                uds = s;
                break;
            }
            catch (Exception e) {
                logger.log(Levels.HANDLED, "constraint check failed", e);
            }
        }
        ByteBuffer outBuf = ByteBuffer.allocate(12);
        outBuf.putInt(2);
        outBuf.putLong(uds != null ? fid : 0L);
        OutputStream out = socket.getOutputStream();
        out.write(outBuf.array(), outBuf.arrayOffset(), outBuf.position());
        out.flush();
        if (uds == null) {
            throw new DiscoveryProtocolException("format negotiation failed");
        }
        uds.handleUnicastDiscovery(response, socket, constraints, checker, context, (ByteBuffer)inBuf.flip(), (ByteBuffer)outBuf.flip());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "sent {0} using {1}, {2}, {3}", new Object[]{response, uds, constraints, checker});
        }
    }

    public String toString() {
        ArrayList l = new ArrayList(6);
        for (int i = 0; i < 6; ++i) {
            l.add(this.formatIdMaps[i].values());
        }
        return "DiscoveryV2" + l;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    private static List[] getProviders(ClassLoader ldr) {
        List[] providers = new List[6];
        for (int i = 0; i < providers.length; ++i) {
            providers[i] = new ArrayList();
        }
        Iterator iter = Service.providers(DiscoveryFormatProvider.class, ldr);
        while (iter.hasNext()) {
            Object obj = iter.next();
            boolean used = false;
            for (int i = 0; i < providerTypes.length; ++i) {
                if (!providerTypes[i].isInstance(obj)) continue;
                providers[i].add(obj);
                used = true;
            }
            if (used) continue;
            logger.log(Level.WARNING, "unusable format provider {0}", new Object[]{obj});
        }
        return providers;
    }

    private static Map makeFormatIdMap(List providers) {
        HashMap<Long, DiscoveryFormatProvider> map = new HashMap<Long, DiscoveryFormatProvider>();
        for (DiscoveryFormatProvider p : providers) {
            Long fid = new Long(DiscoveryV2.computeFormatID(p.getFormatName()));
            if (map.keySet().contains(fid)) {
                logger.log(Level.WARNING, "ignoring provider {0} ({1}) with conflicting format ID {2}", new Object[]{p, p.getFormatName(), fid});
                continue;
            }
            map.put(fid, p);
        }
        return map;
    }

    private static long computeFormatID(String format) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] b = md.digest(format.getBytes("UTF-8"));
            return (((long)b[7] & 0xFFL) << 0) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static List asList(Object[] a) {
        return a != null ? Arrays.asList(a) : Collections.EMPTY_LIST;
    }

    static {
        Class[] t = new Class[]{MulticastRequestEncoder.class, MulticastRequestDecoder.class, MulticastAnnouncementEncoder.class, MulticastAnnouncementDecoder.class, UnicastDiscoveryClient.class, UnicastDiscoveryServer.class};
        providerTypes = t;
        instances = new WeakIdentityMap();
        logger = Logger.getLogger(DiscoveryV2.class.getName());
    }

    private static class DatagramBuffers
    implements DatagramBufferFactory {
        private static final int TRIM_THRESHOLD = 512;
        private final List datagrams = new ArrayList();
        private final InetAddress addr;
        private final int maxPacketSize;
        private final byte packetType;
        private final long formatId;

        DatagramBuffers(InetAddress addr, int maxPacketSize, byte packetType, long formatId) {
            this.addr = addr;
            this.maxPacketSize = maxPacketSize;
            this.packetType = packetType;
            this.formatId = formatId;
        }

        @Override
        public ByteBuffer newBuffer() {
            DatagramInfo di = new DatagramInfo();
            this.datagrams.add(di);
            return di.getBuffer();
        }

        DatagramPacket[] getDatagrams() {
            DatagramPacket[] dp = new DatagramPacket[this.datagrams.size()];
            for (int i = 0; i < dp.length; ++i) {
                dp[i] = ((DatagramInfo)this.datagrams.get(i)).getDatagram();
            }
            return dp;
        }

        private class DatagramInfo {
            private final DatagramPacket datagram;
            private final ByteBuffer buf;

            DatagramInfo() {
                this.datagram = new DatagramPacket(new byte[DatagramBuffers.this.maxPacketSize], 0, DatagramBuffers.this.addr, Constants.getDiscoveryPort());
                this.buf = ByteBuffer.wrap(this.datagram.getData());
                this.buf.putInt(2);
                this.buf.put(DatagramBuffers.this.packetType);
                this.buf.putLong(DatagramBuffers.this.formatId);
            }

            ByteBuffer getBuffer() {
                return this.buf;
            }

            DatagramPacket getDatagram() {
                int len = this.buf.position();
                if (this.buf.remaining() > 512) {
                    byte[] b = new byte[len];
                    System.arraycopy(this.datagram.getData(), 0, b, 0, len);
                    this.datagram.setData(b);
                }
                this.datagram.setLength(len);
                return this.datagram;
            }
        }
    }
}

