/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.util.Arrays;
import net.jini.core.lookup.ServiceID;

@InternalApi
public class MulticastAnnouncement {
    protected long sequenceNumber;
    protected String host;
    protected int port;
    protected String[] groups;
    protected ServiceID serviceID;

    public MulticastAnnouncement(long sequenceNumber, String host, int port, String[] groups, ServiceID serviceID) {
        String[] stringArray = groups = groups != null ? (String[])groups.clone() : new String[]{};
        if (host == null || serviceID == null || Arrays.asList(groups).contains(null)) {
            throw new NullPointerException();
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range: " + port);
        }
        this.sequenceNumber = sequenceNumber;
        this.host = host;
        this.port = port;
        this.groups = groups;
        this.serviceID = serviceID;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return (String[])this.groups.clone();
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public void checkConstraints() throws IOException {
    }

    public String toString() {
        return "MulticastAnnouncement[" + this.sequenceNumber + ", " + this.host + ":" + this.port + ", " + Arrays.asList(this.groups) + ", " + this.serviceID + "]";
    }
}

