/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.gigaspaces.api.InternalApi;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import net.jini.core.lookup.ServiceRegistrar;

@InternalApi
public class UnicastResponse {
    protected String host;
    protected int port;
    protected String[] groups;
    protected ServiceRegistrar registrar;
    private byte[] registrarByes;
    private MarshalledObject marshalledObjectRegistrar;

    public UnicastResponse(String host, int port, String[] groups, ServiceRegistrar registrar) {
        this(host, port, groups, registrar, null, null);
    }

    public UnicastResponse(String host, int port, String[] groups, ServiceRegistrar registrar, MarshalledObject marshalledObjectRegistrar, byte[] registrarBytes) {
        String[] stringArray = groups = groups != null ? (String[])groups.clone() : new String[]{};
        if (host == null || registrar == null || Arrays.asList(groups).contains(null)) {
            throw new NullPointerException();
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range: " + port);
        }
        this.host = host;
        this.port = port;
        this.groups = groups;
        this.registrar = registrar;
        this.marshalledObjectRegistrar = marshalledObjectRegistrar;
        this.registrarByes = registrarBytes;
    }

    public byte[] getRegistrarBytes() {
        return this.registrarByes;
    }

    public MarshalledObject getMarshalledObjectRegistrar() {
        return this.marshalledObjectRegistrar;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return (String[])this.groups.clone();
    }

    public ServiceRegistrar getRegistrar() {
        return this.registrar;
    }

    public String toString() {
        return "UnicastResponse[" + this.host + ":" + this.port + ", " + Arrays.asList(this.groups) + ", " + this.registrar + "]";
    }
}

