/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.gigaspaces.start.SystemInfo;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.UnicastResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.discovery.Constants;

public abstract class MultiIPDiscovery {
    public static final int DEFAULT_TIMEOUT = 60000;

    public UnicastResponse getResponse(String host, int port, InvocationConstraints constraints) throws IOException, ClassNotFoundException {
        Discovery disco;
        InetAddress[] addrs = null;
        try {
            addrs = InetAddress.getAllByName(host);
            if ("localhost".equals(host) || "127.0.0.1".equals(host)) {
                ArrayList<InetAddress> tmp = new ArrayList<InetAddress>();
                if (addrs != null) {
                    tmp.addAll(Arrays.asList(addrs));
                }
                tmp.add(InetAddress.getByName(SystemInfo.singleton().network().getHostId()));
                addrs = tmp.toArray(new InetAddress[tmp.size()]);
            }
        }
        catch (UnknownHostException tmp) {
            // empty catch block
        }
        DiscoveryConstraints dc = DiscoveryConstraints.process(constraints);
        int pv = dc.chooseProtocolVersion();
        switch (pv) {
            case 1: {
                disco = Discovery.getProtocol1();
                break;
            }
            case 2: {
                disco = Discovery.getProtocol2(null);
                break;
            }
            default: {
                throw new AssertionError(pv);
            }
        }
        long deadline = dc.getConnectionDeadline(Long.MAX_VALUE);
        long connectionTimeout = this.getTimeout(deadline);
        if (addrs == null) {
            return this.getSingleResponse(host, connectionTimeout, port, dc, disco);
        }
        IOException ioEx = null;
        SecurityException secEx = null;
        ClassNotFoundException cnfEx = null;
        for (int i = 0; i < addrs.length; ++i) {
            try {
                return this.getSingleResponse(addrs[i].getHostAddress(), connectionTimeout, port, dc, disco);
            }
            catch (ClassNotFoundException ex) {
                cnfEx = ex;
                this.singleResponseException(ex, addrs[i], port);
            }
            catch (IOException ex) {
                ioEx = ex;
                this.singleResponseException(ex, addrs[i], port);
            }
            catch (SecurityException ex) {
                secEx = ex;
                this.singleResponseException(ex, addrs[i], port);
            }
            try {
                connectionTimeout = this.getTimeout(deadline);
                continue;
            }
            catch (SocketTimeoutException ex) {
                if (ioEx != null) break;
                ioEx = ex;
                break;
            }
        }
        if (cnfEx != null) {
            throw cnfEx;
        }
        if (ioEx != null) {
            throw ioEx;
        }
        assert (secEx != null);
        throw secEx;
    }

    private long getTimeout(long deadline) throws SocketTimeoutException {
        long now = System.currentTimeMillis();
        if (now >= deadline) {
            throw new SocketTimeoutException("timeout expired before connection attempted");
        }
        return deadline - now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnicastResponse getSingleResponse(String host, long connectionTimeout, int port, DiscoveryConstraints dc, Discovery disco) throws IOException, ClassNotFoundException {
        Socket s = new Socket();
        if (connectionTimeout > Integer.MAX_VALUE) {
            s.connect(new InetSocketAddress(host, port));
        } else {
            s.connect(new InetSocketAddress(host, port), (int)connectionTimeout);
        }
        if (Constants.useSocketTcpNoDelay()) {
            try {
                s.setTcpNoDelay(true);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        if (Constants.useSocketKeepAlive()) {
            try {
                s.setKeepAlive(true);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        s.setSoTimeout(dc.getUnicastSocketTimeout(this.getDefaultUnicastSocketTimeout()));
        try {
            UnicastResponse unicastResponse = this.performDiscovery(disco, dc, s);
            return unicastResponse;
        }
        finally {
            try {
                if (!s.isClosed()) {
                    s.close();
                }
            }
            catch (IOException e) {
                this.socketCloseException(e);
            }
        }
    }

    protected int getDefaultUnicastSocketTimeout() {
        return 60000;
    }

    protected void singleResponseException(Exception ex, InetAddress addr, int port) {
    }

    protected void socketCloseException(IOException ex) {
    }

    protected abstract UnicastResponse performDiscovery(Discovery var1, DiscoveryConstraints var2, Socket var3) throws IOException, ClassNotFoundException;
}

