/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.lease;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;

public abstract class AbstractLeaseMap
implements LeaseMap {
    protected final Map map;

    protected AbstractLeaseMap(Map map) {
        this.map = map;
    }

    protected AbstractLeaseMap(Lease lease, long duration) {
        this(new HashMap(13), lease, duration);
    }

    protected AbstractLeaseMap(Map map, Lease lease, long duration) {
        this(map);
        map.put(lease, new Long(duration));
    }

    protected void checkKey(Object key) {
        if (!this.canContainKey(key)) {
            throw new IllegalArgumentException("key is not valid for this LeaseMap");
        }
    }

    protected static void checkValue(Object value) {
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("value is not a Long");
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        AbstractLeaseMap.checkValue(value);
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        this.checkKey(key);
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        this.checkKey(key);
        AbstractLeaseMap.checkValue(value);
        return this.map.put(key, value);
    }

    public Object remove(Object key) {
        this.checkKey(key);
        return this.map.remove(key);
    }

    public void putAll(Map m) {
        for (Map.Entry e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return new EntrySet(this.map.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private static final class Entry
    implements Map.Entry {
        private final Map.Entry e;

        public Entry(Map.Entry e) {
            this.e = e;
        }

        public Object getKey() {
            return this.e.getKey();
        }

        public Object getValue() {
            return this.e.getValue();
        }

        public Object setValue(Object value) {
            AbstractLeaseMap.checkValue(value);
            return this.e.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            return this.e.equals(o);
        }

        @Override
        public int hashCode() {
            return this.e.hashCode();
        }
    }

    private static final class EntryIterator
    implements Iterator {
        private final Iterator iter;

        public EntryIterator(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return new Entry((Map.Entry)this.iter.next());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private static final class EntrySet
    extends AbstractSet {
        private final Set set;

        public EntrySet(Set set) {
            this.set = set;
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator(this.set.iterator());
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public void clear() {
            this.set.clear();
        }
    }
}

