/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.loader.pref.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public final class PreferredResources {
    public static final int NAME_NO_PREFERENCE = 0;
    public static final int NAME_NOT_PREFERRED = 1;
    public static final int NAME_PREFERRED = 2;
    public static final int NAME_PREFERRED_RESOURCE_EXISTS = 3;
    private static final String HEADER_TITLE = "PreferredResources-Version: ";
    private static final String HEADER_MAJOR_VERSION = "1";
    private static final String HEADER_MINOR_VERSION = "0";
    private static final String PREF_PREFIX = "Preferred:";
    private static final String NAME_PREFIX = "Name:";
    private Map namespacePrefs;
    private Map packagePrefs;
    private Map completeNamePrefs;
    private boolean isEmpty = true;
    private Boolean defaultPreference = Boolean.FALSE;

    public PreferredResources(InputStream in) throws IOException {
        this.read(in);
    }

    private void read(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF8"));
        String line = null;
        String name = null;
        Boolean preference = null;
        this.isEmpty = true;
        this.completeNamePrefs = new HashMap(53);
        this.packagePrefs = new HashMap(23);
        this.namespacePrefs = new HashMap(11);
        line = this.readLineTrimComments(br);
        if (line != null) {
            if (!line.startsWith(HEADER_TITLE)) {
                throw new IOException("unsupported preferred list header: " + line);
            }
            String version = line.substring(HEADER_TITLE.length(), line.length()).trim();
            if (!version.startsWith("1.")) {
                throw new IOException("preferred list major version not supported");
            }
            line = this.readLineTrimComments(br);
            while (line != null) {
                if (line.length() != 0) {
                    if (line.startsWith(NAME_PREFIX)) {
                        if (name != null) {
                            throw new IOException("Preferred name without preference value");
                        }
                        name = line.substring(NAME_PREFIX.length()).trim();
                    } else {
                        String value;
                        if (line.startsWith(PREF_PREFIX)) {
                            value = line.substring(PREF_PREFIX.length()).trim();
                            if (value.equals("")) {
                                throw new IOException("Empty preference value not permitted");
                            }
                        } else {
                            throw new IOException("unrecognized preference entry: " + line);
                        }
                        preference = Boolean.valueOf(value);
                        if (name == null) {
                            if (preference != null) {
                                if (!this.isEmpty) {
                                    throw new IOException("default preference must be the first expression and can not be redefined");
                                }
                                this.defaultPreference = preference;
                                preference = null;
                                this.isEmpty = false;
                            }
                        } else if (preference != null) {
                            if (name.startsWith("/") || name.startsWith("*") || name.startsWith("-") || name.startsWith(".")) {
                                throw new IOException("Invalid character at name beginning: " + name);
                            }
                            if (name.endsWith("/*")) {
                                this.mapPut(this.packagePrefs, name.substring(0, name.length() - 2), preference);
                            } else if (name.endsWith("/-")) {
                                this.mapPut(this.namespacePrefs, name.substring(0, name.length() - 2), preference);
                            } else if (name.endsWith("/")) {
                                this.mapPut(this.packagePrefs, name.substring(0, name.length() - 1), preference);
                            } else {
                                int state = preference != false ? 2 : 1;
                                this.mapPut(this.completeNamePrefs, name, new Integer(state));
                            }
                            preference = null;
                            name = null;
                        }
                    }
                }
                line = this.readLineTrimComments(br);
            }
            if (name != null) {
                throw new IOException("Preferred name without preference value");
            }
        }
        if (this.isEmpty) {
            throw new IOException("Empty preferences list is invalid");
        }
    }

    private String readLineTrimComments(BufferedReader br) throws IOException {
        String line = br.readLine();
        if (line != null && (line = line.trim()).indexOf(35) == 0) {
            line = "";
        }
        return line;
    }

    private void mapPut(Map map, String name, Object preference) throws IOException {
        this.isEmpty = false;
        if (name.length() == 0 || name == null) {
            throw new IOException("no name specified in preference expression");
        }
        if (map.put(name, preference) != null) {
            throw new IOException("duplicate map entry: " + name);
        }
    }

    public void write(OutputStream out) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, "UTF8"));
        bw.write("PreferredResources-Version: 1.0\n");
        bw.write("Preferred: " + this.defaultPreference + "\n\n");
        this.writeMap(this.completeNamePrefs, bw, "");
        this.writeMap(this.packagePrefs, bw, "/*");
        this.writeMap(this.namespacePrefs, bw, "/-");
        bw.flush();
    }

    private void writeMap(Map prefs, Writer out, String suffix) throws IOException {
        for (Object current : new TreeSet(prefs.keySet())) {
            out.write("Name: " + current + suffix + "\n");
            Object value = prefs.get(current);
            if (value instanceof Boolean) {
                out.write("Preferred: " + value + "\n\n");
                continue;
            }
            if (!(value instanceof Integer)) continue;
            int state = (Integer)value;
            if (state == 2 || state == 3) {
                out.write("Preferred: true\n\n");
                continue;
            }
            out.write("Preferred: false\n\n");
        }
    }

    public Boolean getDefaultPreference() {
        return this.defaultPreference;
    }

    public void setNameState(String name, int prefState) throws IOException {
        this.isEmpty = false;
        if (name.length() == 0) {
            throw new IOException("no name specified in preference expression");
        }
        this.completeNamePrefs.put(name, new Integer(prefState));
    }

    public int getNameState(String name, boolean isClass) throws IOException {
        Integer state = null;
        state = isClass ? this.getClassNameState(name) : (Integer)this.completeNamePrefs.get(name);
        if (state != null) {
            return state;
        }
        return 0;
    }

    private Integer getClassNameState(String name) throws IOException {
        if (!name.endsWith(".class")) {
            throw new IOException("requested name state on a non-class resource: " + name);
        }
        Integer state = null;
        String container = name;
        int lastDollar = -1;
        do {
            if ((state = (Integer)this.completeNamePrefs.get(container)) != null || (lastDollar = container.lastIndexOf("$")) < 0) continue;
            container = container.substring(0, lastDollar) + ".class";
        } while (lastDollar >= 0 && state == null);
        return state;
    }

    public Boolean getWildcardPreference(String name) {
        String mostSpecific;
        Boolean wildcardPref = null;
        int lastSlash = name.lastIndexOf("/");
        if (lastSlash >= 0 && !(mostSpecific = name.substring(0, lastSlash)).equals("")) {
            if (!this.packagePrefs.isEmpty()) {
                wildcardPref = (Boolean)this.packagePrefs.get(mostSpecific);
            }
            if (wildcardPref == null) {
                wildcardPref = this.getNamespacePreference(mostSpecific);
            }
        }
        return wildcardPref;
    }

    private Boolean getNamespacePreference(String namespace) {
        Boolean namespacePref = null;
        if (!this.namespacePrefs.isEmpty()) {
            int lastSlash;
            do {
                namespacePref = (Boolean)this.namespacePrefs.get(namespace);
                lastSlash = namespace.lastIndexOf("/");
                if (lastSlash < 0) continue;
                namespace = namespace.substring(0, lastSlash);
            } while (lastSlash >= 0 && !namespace.equals("") && namespacePref == null);
        }
        return namespacePref;
    }
}

