/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.mahalo.TxnManager;
import com.sun.jini.proxy.DefaultProxyPivot;
import com.sun.jini.proxy.MarshalPivot;
import com.sun.jini.proxy.MarshalPivotProvider;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.rmi.RemoteException;
import java.util.List;
import net.jini.admin.Administrable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ExtendedTransactionManager;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

@InternalApi
public class TxnMgrProxy
implements ExtendedTransactionManager,
Administrable,
Externalizable,
ReferentUuid,
MarshalPivotProvider {
    private static final long serialVersionUID = 2L;
    TxnManager backend;
    TxnManager direct;
    public Uuid proxyID;

    static TxnMgrProxy create(TxnManager txnMgr, Uuid id) {
        if (txnMgr instanceof RemoteMethodControl) {
            return new ConstrainableTxnMgrProxy(txnMgr, id, null);
        }
        return new TxnMgrProxy(txnMgr, id);
    }

    public static TxnMgrProxy create(TxnManager txnMgr, TxnManager direct, Uuid id) {
        return new TxnMgrProxy(txnMgr, direct, id);
    }

    public TxnMgrProxy createLightProxy() {
        return new TxnMgrProxy(null, this.direct, this.proxyID);
    }

    public TxnMgrProxy() {
    }

    private TxnMgrProxy(TxnManager txnMgr, Uuid id) {
        this(txnMgr, null, id);
    }

    private TxnMgrProxy(TxnManager txnMgr, TxnManager direct, Uuid id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot accept null arguments");
        }
        this.backend = txnMgr;
        this.direct = direct;
        this.proxyID = id;
    }

    @Override
    public TransactionManager.Created create(long lease) throws LeaseDeniedException, RemoteException {
        TransactionManager.Created create = this.getProxy().create(lease);
        if (create.lease instanceof LandlordLease) {
            LandlordLease landlordLease = (LandlordLease)create.lease;
            landlordLease.setLandlord(this.backend);
        }
        return create;
    }

    @Override
    public void join(long id, TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.getProxy().join(id, part, crashCount);
    }

    @Override
    public boolean disJoin(long id, TransactionParticipant part) throws UnknownTransactionException, RemoteException {
        return this.getProxy().disJoin(id, part);
    }

    @Override
    public int getState(long id) throws UnknownTransactionException, RemoteException {
        return this.getProxy().getState(id);
    }

    @Override
    public void commit(long id) throws UnknownTransactionException, CannotCommitException, RemoteException {
        this.getProxy().commit(id);
    }

    @Override
    public void commit(long id, long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        this.getProxy().commit(id, waitFor);
    }

    @Override
    public void abort(long id) throws UnknownTransactionException, CannotAbortException, RemoteException {
        this.getProxy().abort(id);
    }

    @Override
    public void abort(long id, long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        this.getProxy().abort(id, waitFor);
    }

    @Override
    public int prepare(Object xid) throws CannotCommitException, UnknownTransactionException, RemoteException {
        return this.getProxy().prepare(xid);
    }

    @Override
    public void commit(Object xid) throws UnknownTransactionException, CannotCommitException, RemoteException {
        this.getProxy().commit(xid);
    }

    @Override
    public void commit(Object xid, long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        this.getProxy().commit(xid, waitFor);
    }

    @Override
    public void abort(Object xid) throws UnknownTransactionException, CannotAbortException, RemoteException {
        this.getProxy().abort(xid);
    }

    @Override
    public void abort(Object xid, long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        this.getProxy().abort(xid, waitFor);
    }

    @Override
    public TransactionManager.Created create(Object xid, long lease) throws LeaseDeniedException, RemoteException {
        TransactionManager.Created create = this.getProxy().create(xid, lease);
        if (create.lease instanceof LandlordLease) {
            LandlordLease landlordLease = (LandlordLease)create.lease;
            landlordLease.setLandlord(this.backend);
        }
        return create;
    }

    @Override
    public int getState(Object xid) throws UnknownTransactionException, RemoteException {
        return this.getProxy().getState(xid);
    }

    @Override
    public void join(Object id, TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.getProxy().join(id, part, crashCount);
    }

    @Override
    @Deprecated
    public void join(long id, TransactionParticipant part, long crashCount, ServerTransaction userXtnObject) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (!userXtnObject.isEmbeddedMgrProxySideInstance()) {
            throw new UnsupportedOperationException(" supported only with embedded mahalo");
        }
        this.getProxy().join(id, part, crashCount, userXtnObject);
    }

    @Override
    @Deprecated
    public void join(Object id, TransactionParticipant part, long crashCount, ServerTransaction userXtnObject) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (!userXtnObject.isEmbeddedMgrProxySideInstance()) {
            throw new UnsupportedOperationException(" supported only with embedded mahalo");
        }
        this.getProxy().join(id, part, crashCount, userXtnObject);
    }

    @Override
    public void join(long id, TransactionParticipant part, long crashCount, int partitionId, String clusterName) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.getProxy().join(id, part, crashCount, partitionId, clusterName);
    }

    @Override
    public void join(Object id, TransactionParticipant part, long crashCount, int partitionId, String clusterName) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.getProxy().join(id, part, crashCount, partitionId, clusterName);
    }

    @Override
    public void join(long id, TransactionParticipant part, long crashCount, ServerTransaction userXtnObject, int partitionId, String clusterName, Object clusterProxy) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (!userXtnObject.isEmbeddedMgrProxySideInstance()) {
            throw new UnsupportedOperationException(" supported only with embedded mahalo");
        }
        this.getProxy().join(id, part, crashCount, userXtnObject, partitionId, clusterName, clusterProxy);
    }

    @Override
    public void join(Object id, TransactionParticipant part, long crashCount, ServerTransaction userXtnObject, int partitionId, String clusterName, Object clusterProxy) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (!userXtnObject.isEmbeddedMgrProxySideInstance()) {
            throw new UnsupportedOperationException(" supported only with embedded mahalo");
        }
        this.getProxy().join(id, part, crashCount, userXtnObject, partitionId, clusterName, clusterProxy);
    }

    public void reenterPreparedExternalXid(Object xid, List<TransactionParticipant> parts) throws RemoteException, CannotCommitException {
        this.getProxy().reenterPreparedExternalXid(xid, parts);
    }

    @Override
    public Object getAdmin() throws RemoteException {
        return this.getProxy().getAdmin();
    }

    @Override
    public Uuid getReferentUuid() {
        return this.proxyID;
    }

    public int hashCode() {
        return this.proxyID.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TxnMgrProxy) {
            TxnMgrProxy other = (TxnMgrProxy)o;
            return this.proxyID.getLeastSignificantBits() == other.proxyID.getLeastSignificantBits() && this.proxyID.getMostSignificantBits() == other.proxyID.getMostSignificantBits();
        }
        return false;
    }

    public TxnManager getProxy() {
        if (this.direct != null) {
            return this.direct;
        }
        return this.backend;
    }

    @Override
    public boolean needParticipantsJoin() {
        return true;
    }

    public boolean isEmbeddedMgr() {
        return this.direct != null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.backend != null) {
            out.writeBoolean(true);
            out.writeObject(this.backend);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.proxyID.getMostSignificantBits());
        out.writeLong(this.proxyID.getLeastSignificantBits());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.backend = (TxnManager)in.readObject();
        }
        this.proxyID = new Uuid(in.readLong(), in.readLong());
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data found when attempting to deserialize TxnMgrProxy instance");
    }

    @Override
    public MarshalPivot getMarshalPivot() throws RemoteException {
        return new DefaultProxyPivot(this.backend);
    }

    public String toString() {
        return "TxnMgrProxy [proxyId=" + this.proxyID.toString() + ", isDirect=" + (this.direct != null) + "]";
    }

    @Override
    public Uuid getTransactionManagerId() throws RemoteException {
        return this.proxyID;
    }

    static final class ConstrainableTxnMgrProxy
    extends TxnMgrProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;

        public ConstrainableTxnMgrProxy() {
        }

        private ConstrainableTxnMgrProxy(TxnManager txnMgr, Uuid id, MethodConstraints methodConstraints) {
            super(ConstrainableTxnMgrProxy.constrainServer(txnMgr, methodConstraints), id);
        }

        private static TxnManager constrainServer(TxnManager txnMgr, MethodConstraints methodConstraints) {
            return (TxnManager)((Object)((RemoteMethodControl)((Object)txnMgr)).setConstraints(methodConstraints));
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableTxnMgrProxy(this.backend, this.proxyID, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)((Object)this.backend)).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.backend);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.backend instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableTxnMgrProxy.readObject failure - backend does not implement constrainable functionality ");
            }
        }
    }
}

