/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.proxy;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.proxy.MarshalPivot;
import com.sun.jini.start.ServiceProxyAccessor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

@InternalApi
public class DefaultProxyPivot
implements MarshalPivot,
Externalizable {
    private static final ThreadLocal<Boolean> LAZY_ACCESS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final long serialVersionUID = 1L;
    private static final byte SERIAL_VERSION = -128;
    private ServiceProxyAccessor service;

    public DefaultProxyPivot() {
    }

    public DefaultProxyPivot(ServiceProxyAccessor service) {
        this.service = service;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(-128);
        out.writeObject(this.service);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        if (version != -128) {
            throw new UnmarshalException("Requested version [" + version + "] does not match local version [" + -128 + "].");
        }
        this.service = (ServiceProxyAccessor)in.readObject();
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        try {
            return DefaultProxyPivot.isLazyAccess() ? this.service : this.service.getServiceProxy();
        }
        catch (RemoteException e) {
            NotActiveException streamException = new NotActiveException("Failed to retrieve proxy from service, cause " + e.getMessage());
            streamException.initCause(e);
            throw streamException;
        }
    }

    public static boolean updateLazyAccess(boolean lazyAccess) {
        boolean previousValue = DefaultProxyPivot.isLazyAccess();
        LAZY_ACCESS.set(lazyAccess);
        return previousValue;
    }

    private static boolean isLazyAccess() {
        return LAZY_ACCESS.get();
    }
}

