/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.collection.WeakIdentityMap;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Map;
import java.util.WeakHashMap;
import net.jini.security.SecurityContext;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.PolicyInitializationException;
import net.jini.security.policy.SecurityContextSource;

@InternalApi
public class AggregatePolicyProvider
extends Policy
implements DynamicPolicy,
SecurityContextSource {
    private static final String mainPolicyClassProperty = "com.sun.jini.start.AggregatePolicyProvider.mainPolicyClass";
    private static final String defaultMainPolicyClass = "net.jini.security.policy.DynamicPolicyProvider";
    private static final Map trustGetCCL = new WeakHashMap();
    private static final ProtectionDomain myDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return AggregatePolicyProvider.class.getProtectionDomain();
        }
    });
    private WeakIdentityMap subPolicies = new WeakIdentityMap();
    private WeakIdentityMap subPolicyCache = new WeakIdentityMap();
    private Policy mainPolicy;

    public AggregatePolicyProvider() throws PolicyInitializationException {
        String cname = Security.getProperty(mainPolicyClassProperty);
        if (cname == null) {
            cname = defaultMainPolicyClass;
        }
        try {
            this.mainPolicy = (Policy)Class.forName(cname).newInstance();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PolicyInitializationException("unable to construct main policy", e);
        }
        this.ensureDependenciesResolved();
    }

    public AggregatePolicyProvider(Policy mainPolicy) {
        if (mainPolicy == null) {
            throw new NullPointerException();
        }
        this.mainPolicy = mainPolicy;
        this.ensureDependenciesResolved();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource source) {
        return this.getCurrentSubPolicy().getPermissions(source);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (domain == myDomain) {
            Permissions pc = new Permissions();
            ((PermissionCollection)pc).add(new AllPermission());
            return pc;
        }
        return this.getCurrentSubPolicy().getPermissions(domain);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        return domain == myDomain || this.getCurrentSubPolicy().implies(domain, permission);
    }

    @Override
    public void refresh() {
        this.getCurrentSubPolicy().refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolicy(ClassLoader loader, Policy subPolicy) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        WeakIdentityMap weakIdentityMap = this.subPolicies;
        synchronized (weakIdentityMap) {
            this.subPolicyCache.clear();
            if (loader != null) {
                if (subPolicy != null) {
                    this.subPolicies.put(loader, subPolicy);
                    this.subPolicyCache.put(loader, subPolicy);
                } else {
                    this.subPolicies.remove(loader);
                }
            } else {
                if (subPolicy == null) {
                    throw new NullPointerException();
                }
                this.mainPolicy = subPolicy;
            }
        }
    }

    @Override
    public boolean grantSupported() {
        Policy p = this.getCurrentSubPolicy();
        return p instanceof DynamicPolicy && ((DynamicPolicy)((Object)p)).grantSupported();
    }

    @Override
    public void grant(Class cl, Principal[] principals, Permission[] permissions) {
        Policy p = this.getCurrentSubPolicy();
        if (!(p instanceof DynamicPolicy)) {
            throw new UnsupportedOperationException("grants not supported");
        }
        ((DynamicPolicy)((Object)p)).grant(cl, principals, permissions);
    }

    @Override
    public Permission[] getGrants(Class cl, Principal[] principals) {
        Policy p = this.getCurrentSubPolicy();
        if (p instanceof DynamicPolicy) {
            return ((DynamicPolicy)((Object)p)).getGrants(cl, principals);
        }
        throw new UnsupportedOperationException("grants not supported");
    }

    @Override
    public SecurityContext getContext() {
        Policy p = this.getCurrentSubPolicy();
        SecurityContext sc = p instanceof SecurityContextSource ? ((SecurityContextSource)((Object)p)).getContext() : new DefaultSecurityContext();
        return new AggregateSecurityContext(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDependenciesResolved() {
        ClassLoader ldr = this.getClass().getClassLoader();
        if (ldr == null) {
            ldr = ClassLoader.getSystemClassLoader();
        }
        AggregatePolicyProvider.trustGetContextClassLoader0(Thread.class);
        AggregatePolicyProvider.getContextClassLoader();
        WeakIdentityMap weakIdentityMap = this.subPolicies;
        synchronized (weakIdentityMap) {
            this.lookupSubPolicy(ldr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy getCurrentSubPolicy() {
        Thread t = Thread.currentThread();
        if (!AggregatePolicyProvider.trustGetContextClassLoader(t)) {
            return this.mainPolicy;
        }
        ClassLoader ccl = AggregatePolicyProvider.getContextClassLoader();
        WeakIdentityMap weakIdentityMap = this.subPolicies;
        synchronized (weakIdentityMap) {
            Policy policy = (Policy)this.subPolicyCache.get(ccl);
            if (policy == null) {
                policy = this.lookupSubPolicy(ccl);
                this.subPolicyCache.put(ccl, policy);
            }
            return policy;
        }
    }

    private Policy lookupSubPolicy(final ClassLoader ldr) {
        assert (Thread.holdsLock(this.subPolicies));
        return (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (ClassLoader l = ldr; l != null; l = l.getParent()) {
                    Policy p = (Policy)AggregatePolicyProvider.this.subPolicies.get(l);
                    if (p == null) continue;
                    return p;
                }
                return AggregatePolicyProvider.this.mainPolicy;
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean trustGetContextClassLoader(Thread t) {
        Boolean b;
        Class<?> cl = t.getClass();
        if (cl == Thread.class) {
            return true;
        }
        Map map = trustGetCCL;
        synchronized (map) {
            b = (Boolean)trustGetCCL.get(cl);
        }
        if (b == null) {
            b = AggregatePolicyProvider.trustGetContextClassLoader0(cl);
            map = trustGetCCL;
            synchronized (map) {
                trustGetCCL.put(cl, b);
            }
        }
        return b;
    }

    private static Boolean trustGetContextClassLoader0(final Class cl) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method m = cl.getMethod("getContextClassLoader", new Class[0]);
                    return m.getDeclaringClass() == Thread.class;
                }
                catch (NoSuchMethodException ex) {
                    throw new InternalError("Thread.getContextClassLoader() not found");
                }
            }
        });
    }

    private static class AggregateSecurityContext
    implements SecurityContext {
        private final ClassLoader ccl = AggregatePolicyProvider.getContextClassLoader();
        private final SecurityContext sc;

        AggregateSecurityContext(SecurityContext sc) {
            if (sc == null) {
                throw new NullPointerException();
            }
            this.sc = sc;
        }

        @Override
        public PrivilegedAction wrap(PrivilegedAction a) {
            final PrivilegedAction wa = this.sc.wrap(a);
            return new PrivilegedAction(){

                public Object run() {
                    Object t;
                    ClassLoader sccl = this.setCCL(ccl, false);
                    try {
                        t = wa.run();
                    }
                    catch (Throwable throwable) {
                        this.setCCL(sccl, sccl != ccl);
                        throw throwable;
                    }
                    this.setCCL(sccl, sccl != ccl);
                    return t;
                }
            };
        }

        @Override
        public PrivilegedExceptionAction wrap(PrivilegedExceptionAction a) {
            final PrivilegedExceptionAction wa = this.sc.wrap(a);
            return new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object t;
                    ClassLoader sccl = this.setCCL(ccl, false);
                    try {
                        t = wa.run();
                    }
                    catch (Throwable throwable) {
                        this.setCCL(sccl, sccl != ccl);
                        throw throwable;
                    }
                    this.setCCL(sccl, sccl != ccl);
                    return t;
                }
            };
        }

        @Override
        public AccessControlContext getAccessControlContext() {
            return this.sc.getAccessControlContext();
        }

        private ClassLoader setCCL(final ClassLoader ldr, final boolean force) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread t = Thread.currentThread();
                    ClassLoader old = null;
                    if (force || ldr != (old = t.getContextClassLoader())) {
                        t.setContextClassLoader(ldr);
                    }
                    return old;
                }
            });
        }
    }

    private static class DefaultSecurityContext
    implements SecurityContext {
        private final AccessControlContext acc = AccessController.getContext();

        private DefaultSecurityContext() {
        }

        @Override
        public PrivilegedAction wrap(PrivilegedAction a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return a;
        }

        @Override
        public PrivilegedExceptionAction wrap(PrivilegedExceptionAction a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return a;
        }

        @Override
        public AccessControlContext getAccessControlContext() {
            return this.acc;
        }
    }
}

