/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.start.ServiceStarter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class HTTPDStatus {
    private static final Logger logger = ServiceStarter.logger;

    private HTTPDStatus() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: HTTPDStatus URL1 [URL2 ... URLN]");
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            HTTPDStatus.httpdWarning(args[i]);
        }
    }

    public static void httpdWarning(String codebase) {
        if (codebase == null) {
            logger.log(Level.WARNING, "httpserver.warning", new Object[]{codebase, "Codebase is null"});
            return;
        }
        StringTokenizer st = new StringTokenizer(codebase, " ");
        String url = null;
        URL u = null;
        int i = 0;
        while (st.hasMoreTokens()) {
            url = st.nextToken();
            try {
                u = new URL(url);
                String fileName = u.getFile();
                if (fileName == null || fileName.endsWith("/")) {
                    logger.log(Level.FINEST, "httpserver.skipping", url);
                } else {
                    try {
                        HTTPDStatus.drainStream(u.openStream());
                    }
                    catch (Exception ioe) {
                        logger.log(Level.WARNING, "httpserver.warning", new Object[]{url, ioe.toString()});
                        logger.log(Level.FINEST, "httpserver.exception", ioe);
                    }
                }
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "httpserver.unknownprotocol", url);
                logger.log(Level.FINEST, "httpserver.exception", e);
            }
            ++i;
        }
    }

    private static void drainStream(InputStream is) throws IOException {
        BufferedInputStream reader = new BufferedInputStream(is);
        while (reader.read() != -1) {
        }
    }
}

