/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.config.Config;
import com.sun.jini.start.NonActivatableServiceDescriptor;
import com.sun.jini.start.ServiceDescriptor;
import java.rmi.Naming;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationSystem;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

@InternalApi
public class ServiceStarter {
    static final String START_PACKAGE = "com.sun.jini.start";
    static Logger logger = null;
    private static ArrayList transient_service_refs;

    private ServiceStarter() {
    }

    private static Result[] createWithLogin(final ServiceDescriptor[] descs, final Configuration config, LoginContext loginContext) throws Exception {
        logger.entering(ServiceStarter.class.getName(), "createWithLogin", new Object[]{descs, config, loginContext});
        loginContext.login();
        Result[] results = null;
        try {
            results = (Result[])Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ServiceStarter.create(descs, config);
                }
            }, null);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        finally {
            try {
                loginContext.logout();
            }
            catch (LoginException le) {
                logger.log(Level.FINE, "service.logout.exception", le);
            }
        }
        logger.exiting(ServiceStarter.class.getName(), "createWithLogin", results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result[] create(ServiceDescriptor[] descs, Configuration config) throws Exception {
        logger.entering(ServiceStarter.class.getName(), "create", new Object[]{descs, config});
        ArrayList<Result> proxies = new ArrayList<Result>();
        Object result = null;
        Exception problem = null;
        ServiceDescriptor desc = null;
        for (int i = 0; i < descs.length; ++i) {
            desc = descs[i];
            result = null;
            problem = null;
            try {
                if (desc == null) continue;
                result = desc.create(config);
                continue;
            }
            catch (Exception e) {
                problem = e;
                continue;
            }
            finally {
                proxies.add(new Result(desc, result, problem));
            }
        }
        logger.exiting(ServiceStarter.class.getName(), "create", proxies);
        return proxies.toArray(new Result[proxies.size()]);
    }

    static ActivationSystem getActivationSystem(String host, int port, Configuration config) throws ActivationException, ConfigurationException {
        if (config == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        ActivationSystem sys = null;
        String h = host == null ? "" : host;
        int p = port <= 0 ? ServiceStarter.getActivationSystemPort() : port;
        try {
            sys = (ActivationSystem)Naming.lookup("//" + h + ":" + p + "/java.rmi.activation.ActivationSystem");
            ProxyPreparer activationSystemPreparer = (ProxyPreparer)Config.getNonNullEntry(config, START_PACKAGE, "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            sys = (ActivationSystem)activationSystemPreparer.prepareProxy(sys);
        }
        catch (Exception e) {
            throw new ActivationException("ActivationSystem @ " + host + ":" + port + " could not be obtained", (Throwable)e);
        }
        return sys;
    }

    static int getActivationSystemPort() {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction("java.rmi.activation.port", 1098));
    }

    private static void maintainNonActivatableReferences(Result[] results) {
        logger.entering(ServiceStarter.class.getName(), "maintainNonActivatableReferences", results);
        if (results.length == 0) {
            return;
        }
        transient_service_refs = new ArrayList();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] == null || results[i].result == null || !NonActivatableServiceDescriptor.class.equals(results[i].descriptor.getClass())) continue;
            logger.log(Level.FINEST, "Storing ref to: {0}", results[i].result);
            transient_service_refs.add(results[i].result);
        }
        logger.exiting(ServiceStarter.class.getName(), "maintainNonActivatableReferences");
    }

    private static void checkResultFailures(Result[] results) {
        logger.entering(ServiceStarter.class.getName(), "checkResultFailures", results);
        if (results.length == 0) {
            return;
        }
        for (int i = 0; i < results.length; ++i) {
            if (results[i].exception != null) {
                logger.log(Level.WARNING, "service.creation.unknown", results[i].exception);
                logger.log(Level.WARNING, "service.creation.unknown.detail", new Object[]{new Integer(i), results[i].descriptor});
                continue;
            }
            if (results[i].descriptor != null) continue;
            logger.log(Level.WARNING, "service.creation.null", new Integer(i));
        }
        logger.exiting(ServiceStarter.class.getName(), "checkResultFailures");
    }

    public static void main(String[] args) {
        try {
            logger.entering(ServiceStarter.class.getName(), "main", args);
            Configuration config = ConfigurationProvider.getInstance(args);
            ServiceDescriptor[] descs = (ServiceDescriptor[])config.getEntry(START_PACKAGE, "serviceDescriptors", ServiceDescriptor[].class, null);
            if (descs == null || descs.length == 0) {
                logger.warning("service.config.empty");
                return;
            }
            LoginContext loginContext = (LoginContext)config.getEntry(START_PACKAGE, "loginContext", LoginContext.class, null);
            Result[] results = null;
            results = loginContext != null ? ServiceStarter.createWithLogin(descs, config, loginContext) : ServiceStarter.create(descs, config);
            ServiceStarter.checkResultFailures(results);
            ServiceStarter.maintainNonActivatableReferences(results);
        }
        catch (ConfigurationException cex) {
            logger.log(Level.SEVERE, "service.config.exception", cex);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "service.creation.exception", e);
        }
        logger.exiting(ServiceStarter.class.getName(), "main");
    }

    static {
        try {
            logger = Logger.getLogger("com.sun.jini.start.service.starter", "com.sun.jini.start.resources.service");
        }
        catch (Exception e) {
            logger = Logger.getLogger("com.sun.jini.start.service.starter");
            if (e instanceof MissingResourceException) {
                logger.info("Could not load logger's ResourceBundle: " + e);
            } else if (e instanceof IllegalArgumentException) {
                logger.info("Logger exists and uses another resource bundle: " + e);
            }
            logger.info("Defaulting to existing logger");
        }
    }

    private static class Result {
        public final Object result;
        public final Exception exception;
        public final ServiceDescriptor descriptor;

        Result(ServiceDescriptor d, Object o, Exception e) {
            this.descriptor = d;
            this.result = o;
            this.exception = e;
        }

        public String toString() {
            return this.getClass() + ":[descriptor=" + this.descriptor + ", result=" + this.result + ", exception=" + this.exception + "]";
        }
    }
}

