/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import com.gigaspaces.api.InternalApi;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;

@InternalApi
public class AggregateConfig
implements Configuration {
    Configuration common = null;
    private Configuration specific;

    public AggregateConfig(Configuration config, String[] configArgs) throws ConfigurationException {
        this.specific = ConfigurationProvider.getInstance(configArgs);
        this.common = config;
    }

    public AggregateConfig(Configuration config, String[] configArgs, ClassLoader loader) throws ConfigurationException {
        this.specific = ConfigurationProvider.getInstance(configArgs, loader);
        this.common = config;
    }

    public AggregateConfig(String[] configs) throws ConfigurationException {
        this.specific = ConfigurationProvider.getInstance(configs);
    }

    public AggregateConfig(String[] configs, ClassLoader loader) throws ConfigurationException {
        this.specific = ConfigurationProvider.getInstance(configs, loader);
    }

    public Configuration getCommonConfiguration() {
        return this.common;
    }

    private String getSharedComponent(String name) throws ConfigurationException {
        int ndx = name.lastIndexOf("_");
        if (ndx == -1) {
            throw new ConfigurationException("unknown component name for " + name);
        }
        String sharedComponent = name.substring(1, ndx);
        return sharedComponent.replace('_', '.');
    }

    private String getSharedEntryName(String name) throws ConfigurationException {
        int ndx = name.lastIndexOf("_");
        if (ndx == -1) {
            throw new ConfigurationException("unknown component name for " + name);
        }
        return name.substring(ndx + 1);
    }

    @Override
    public Object getEntry(String component, String name, Class type) throws ConfigurationException {
        try {
            return this.specific.getEntry(component, name, type);
        }
        catch (NoSuchEntryException e) {
            return this.common.getEntry(component, name, type);
        }
    }

    @Override
    public Object getEntry(String component, String name, Class type, Object defaultValue) throws ConfigurationException {
        try {
            return this.specific.getEntry(component, name, type);
        }
        catch (NoSuchEntryException e) {
            return this.common.getEntry(component, name, type, defaultValue);
        }
    }

    @Override
    public Object getEntry(String component, String name, Class type, Object defaultValue, Object data) throws ConfigurationException {
        Object retVal = this.specific.getEntry(component, name, type, null, data);
        if (retVal != null) {
            return retVal;
        }
        return this.common.getEntry(component, name, type, defaultValue, data);
    }
}

