/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import com.gigaspaces.api.InternalApi;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import net.jini.config.AbstractConfiguration;
import net.jini.config.ConfigurationEntryFactory;
import net.jini.config.ConfigurationException;
import net.jini.config.NoSuchEntryException;

@InternalApi
public class PlainConfiguration
extends AbstractConfiguration {
    private final HashMap entries = new HashMap();

    @Override
    protected Object getEntryInternal(String component, String name, Class type, Object data) throws ConfigurationException {
        Object entry = this.entries.get(component + '.' + name);
        if (entry == null) {
            String entrySysProperty = System.getProperty(component + "." + name);
            if (entrySysProperty != null) {
                if (type.equals(String.class)) {
                    return entrySysProperty;
                }
                Object number = PlainConfiguration.parseNumber(entrySysProperty, type);
                if (number != null) {
                    return number;
                }
                throw new NoSuchEntryException("Entry for component [" + component + "] and name [" + name + "] can't be parsed, can't handle type [" + type.getName() + "]");
            }
            throw new NoSuchEntryException("No entry for component [" + component + "] and name [" + name + "]");
        }
        if (entry instanceof ConfigurationEntryFactory) {
            entry = ((ConfigurationEntryFactory)entry).create();
        }
        if (type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Float.TYPE) || type.equals(Boolean.TYPE) || type.equals(Short.TYPE) || type.equals(Double.TYPE)) {
            return new AbstractConfiguration.Primitive(entry);
        }
        return entry;
    }

    public void setEntry(String component, String name, Object entry) {
        this.entries.put(component + '.' + name, entry);
    }

    public static Object parseNumber(String text, Class targetClass) {
        String trimmed = PlainConfiguration.trimAllWhitespace(text);
        if (targetClass.equals(Byte.class)) {
            return PlainConfiguration.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed);
        }
        if (targetClass.equals(Boolean.TYPE)) {
            return new AbstractConfiguration.Primitive(PlainConfiguration.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        }
        if (targetClass.equals(Short.class)) {
            return PlainConfiguration.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed);
        }
        if (targetClass.equals(Short.TYPE)) {
            return new AbstractConfiguration.Primitive(PlainConfiguration.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        }
        if (targetClass.equals(Integer.class)) {
            return PlainConfiguration.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed);
        }
        if (targetClass.equals(Integer.TYPE)) {
            return new AbstractConfiguration.Primitive(PlainConfiguration.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        }
        if (targetClass.equals(Long.class)) {
            return PlainConfiguration.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed);
        }
        if (targetClass.equals(Long.TYPE)) {
            return new AbstractConfiguration.Primitive(PlainConfiguration.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        }
        if (targetClass.equals(BigInteger.class)) {
            return PlainConfiguration.isHexNumber(trimmed) ? PlainConfiguration.decodeBigInteger(trimmed) : new BigInteger(trimmed);
        }
        if (targetClass.equals(Float.class)) {
            return Float.valueOf(trimmed);
        }
        if (targetClass.equals(Float.TYPE)) {
            return new AbstractConfiguration.Primitive(Float.valueOf(trimmed));
        }
        if (targetClass.equals(Double.class)) {
            return Double.valueOf(trimmed);
        }
        if (targetClass.equals(Double.TYPE)) {
            return new AbstractConfiguration.Primitive(Double.valueOf(trimmed));
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return new BigDecimal(trimmed);
        }
        return null;
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    public static String trimAllWhitespace(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        int index = 0;
        while (buf.length() > index) {
            if (Character.isWhitespace(buf.charAt(index))) {
                buf.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return buf.toString();
    }
}

