/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import java.io.IOException;
import java.io.Reader;

final class UnicodeEscapesDecodingReader
extends Reader {
    private static final int NO_CHAR = Integer.MIN_VALUE;
    private Reader reader;
    private int peekc = Integer.MIN_VALUE;
    private final char[] code = new char[4];

    UnicodeEscapesDecodingReader(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        this.reader = reader;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.reader == null) {
            throw new IOException("stream is closed");
        }
        return this.readInternal();
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        if (this.reader == null) {
            throw new IOException("stream is closed");
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int nchars = 0; nchars < len; ++nchars) {
            int c = this.readInternal();
            if (c < 0) {
                return nchars == 0 ? -1 : nchars;
            }
            cbuf[off + nchars] = (char)c;
        }
        return len;
    }

    private int readInternal() throws IOException {
        int c;
        if (this.peekc == Integer.MIN_VALUE) {
            c = this.reader.read();
        } else {
            c = this.peekc;
            this.peekc = Integer.MIN_VALUE;
            if (c == 92) {
                return c;
            }
        }
        if (c != 92) {
            return c;
        }
        c = this.reader.read();
        if (c != 117) {
            this.peekc = c;
            return 92;
        }
        while ((c = this.reader.read()) == 117) {
        }
        int nchars = 0;
        if (c >= 0) {
            int n;
            this.code[nchars++] = (char)c;
            while (nchars < 4 && (n = this.reader.read(this.code, nchars, 4 - nchars)) >= 0) {
                nchars += n;
            }
        }
        String s = new String(this.code, 0, nchars);
        if (nchars == 4) {
            try {
                int i = Integer.parseInt(s, 16);
                if (i >= 0) {
                    return (char)i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("illegal Unicode escape: \\u" + s);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }
}

