/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jini.core.constraint.Constraint;

final class ArraySet
implements Set {
    private final Object[] elements;

    ArraySet(Object[] elements) {
        this.elements = elements;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        int i = this.elements.length;
        while (--i >= 0) {
            if (!this.elements[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new Iter();
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, a, 0, this.elements.length);
        return a;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.elements.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.elements.length);
        }
        System.arraycopy(this.elements, 0, a, 0, this.elements.length);
        if (a.length > this.elements.length) {
            a[this.elements.length] = null;
        }
        return a;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Set && ((Collection)o).size() == this.elements.length && this.containsAll((Collection)o);
    }

    @Override
    public int hashCode() {
        return Constraint.hash(this.elements);
    }

    public String toString() {
        return Constraint.toString(this.elements);
    }

    private final class Iter
    implements Iterator {
        private int idx = 0;

        Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < ArraySet.this.elements.length;
        }

        public Object next() {
            if (this.idx < ArraySet.this.elements.length) {
                return ArraySet.this.elements[this.idx++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

