/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.entry;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import net.jini.core.entry.Entry;

@InternalApi
public class UnusableEntryException
extends Exception {
    static final long serialVersionUID = -2199083666668626172L;
    public Entry partialEntry;
    public String[] unusableFields;
    public Throwable[] nestedExceptions;

    public UnusableEntryException(Entry partial, String[] badFields, Throwable[] exceptions) {
        int i;
        if (exceptions != null && exceptions.length > 0) {
            this.initCause(exceptions[0]);
        }
        if (partial == null) {
            if (exceptions.length != 1) {
                throw new IllegalArgumentException("If partial is null exceptions must have one element");
            }
            if (badFields != null) {
                throw new IllegalArgumentException("If partial is null badFields must be null");
            }
        } else if (badFields.length != exceptions.length) {
            throw new IllegalArgumentException("If partial is non-null badFields and exceptions must have same length");
        }
        if (badFields != null) {
            for (i = 0; i < badFields.length; ++i) {
                if (badFields[i] != null) continue;
                throw new NullPointerException("badFields has a null element");
            }
        }
        for (i = 0; i < exceptions.length; ++i) {
            if (exceptions[i] != null) continue;
            throw new NullPointerException("exceptions has a null element");
        }
        this.partialEntry = partial;
        this.unusableFields = badFields;
        this.nestedExceptions = exceptions;
    }

    public UnusableEntryException(Throwable e) {
        this.initCause(e);
        if (e == null) {
            throw new NullPointerException("e must be non-null");
        }
        this.partialEntry = null;
        this.unusableFields = null;
        this.nestedExceptions = new Throwable[]{e};
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        in.defaultReadObject();
        if (this.partialEntry == null) {
            if (this.nestedExceptions.length != 1) {
                throw new InvalidObjectException("If partialEntry is null nestedExceptions must have one element");
            }
            if (this.unusableFields != null) {
                throw new InvalidObjectException("If partialEntry is null unusableFields must be null");
            }
        } else {
            if (this.unusableFields == null) {
                throw new InvalidObjectException("unusableFields is null");
            }
            if (this.nestedExceptions == null) {
                throw new InvalidObjectException("nestedExceptions is null");
            }
            if (this.unusableFields.length != this.nestedExceptions.length) {
                throw new InvalidObjectException("If partialEntry is non-null unusableFields and nestedExceptions must have same length");
            }
        }
        if (this.unusableFields != null) {
            for (i = 0; i < this.unusableFields.length; ++i) {
                if (this.unusableFields[i] != null) continue;
                throw new InvalidObjectException("unusableFields has a null element");
            }
        }
        for (i = 0; i < this.nestedExceptions.length; ++i) {
            if (this.nestedExceptions[i] != null) continue;
            throw new InvalidObjectException("nestedExceptions has a null element");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("UnusableEntryExceptions should always have data");
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (this.unusableFields == null) {
                s.println("Total unmarshalling failure, cause was:");
                this.nestedExceptions[0].printStackTrace(s);
            } else {
                s.println("Partial unmarshalling failure");
                for (int i = 0; i < this.nestedExceptions.length; ++i) {
                    s.println(this.unusableFields[i] + " field could not be unmarshalled because of:");
                    this.nestedExceptions[i].printStackTrace(s);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            if (this.unusableFields == null) {
                s.println("Total unmarshalling failure, cause was:");
                this.nestedExceptions[0].printStackTrace(s);
            } else {
                s.println("Partial unmarshalling failure");
                for (int i = 0; i < this.nestedExceptions.length; ++i) {
                    s.println(this.unusableFields[i] + " field could not be unmarshalled because of:");
                    this.nestedExceptions[i].printStackTrace(s);
                }
            }
        }
    }
}

