/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.transaction.server;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.NestableTransaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.NestableTransactionManager;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;

@InternalApi
public class NestableServerTransaction
extends ServerTransaction
implements NestableTransaction {
    static final long serialVersionUID = -3438419132543972925L;
    public NestableServerTransaction parent;

    public NestableServerTransaction() {
    }

    public NestableServerTransaction(NestableTransactionManager mgr, long id, NestableServerTransaction parent, long lease) {
        super((TransactionManager)mgr, id, lease);
        this.parent = parent;
    }

    @Override
    public NestableTransaction.Created create(NestableTransactionManager mgr, long leaseTime) throws UnknownTransactionException, CannotJoinException, LeaseDeniedException, RemoteException {
        TransactionManager.Created rawTxn = mgr.create((NestableTransactionManager)((Object)this.mgr), this.id, leaseTime);
        NestableServerTransaction tx = new NestableServerTransaction(mgr, rawTxn.id, this, leaseTime);
        return new NestableTransaction.Created(tx, rawTxn.lease);
    }

    @Override
    public NestableTransaction.Created create(long leaseTime) throws UnknownTransactionException, CannotJoinException, LeaseDeniedException, RemoteException {
        return this.create((NestableTransactionManager)((Object)this.mgr), leaseTime);
    }

    public void promote(TransactionParticipant[] parts, long[] crashCounts, TransactionParticipant drop) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        ((NestableTransactionManager)((Object)this.mgr)).promote(this.id, parts, crashCounts, drop);
    }

    public boolean enclosedBy(NestableTransaction enclosing) {
        NestableServerTransaction ancestor = this.parent;
        while (ancestor != null) {
            if (ancestor.equals(enclosing)) {
                return true;
            }
            ancestor = ancestor.parent;
        }
        return false;
    }

    @Override
    public boolean isNested() {
        return this.parent != null;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " [manager=" + this.mgr + ", id=" + this.id + ", parent=" + this.parent + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.parent == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.parent);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.readBoolean()) {
            this.parent = (NestableServerTransaction)in.readObject();
        }
    }
}

