/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.transaction.server;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ISwapExternalizable;
import com.sun.jini.mahalo.TxnMgrProxy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.ManagedTransaction;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ExtendedTransactionManager;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;

@InternalApi
public class ServerTransaction
implements ManagedTransaction,
Serializable,
Externalizable,
ISwapExternalizable {
    private static final long serialVersionUID = 4552277137549765374L;
    public ExtendedTransactionManager mgr;
    public long id;
    private long lease;
    private TransactionParticipantDataImpl metaData;
    private boolean _embeddedMgrInProxy;
    private transient boolean _embeddedMgrProxySideInstance;
    public static final long EMBEDDED_CRASH_COUNT = Long.MAX_VALUE;
    private static final long DEFAULT_COMMIT_ABORT_TIMEOUT = Long.MAX_VALUE;

    public ServerTransaction() {
    }

    public ServerTransaction(TransactionManager mgr, long id, long lease) {
        this.mgr = (ExtendedTransactionManager)mgr;
        this.id = id;
        this.lease = lease;
    }

    public ServerTransaction(TransactionManager mgr, long id) {
        this(mgr, id, -1L);
    }

    public ServerTransaction(TransactionManager mgr, long id, TransactionParticipantDataImpl metaData) {
        this(mgr, id);
        this.metaData = metaData;
    }

    public static ServerTransaction create(TransactionManager mgr, long id, long lease) throws RemoteException {
        ServerTransaction txn = new ServerTransaction(mgr, id, lease);
        txn.initEmbedded();
        return txn;
    }

    protected void initEmbedded() throws RemoteException {
        if (this.mgr.needParticipantsJoin()) {
            if (((TxnMgrProxy)this.mgr).isEmbeddedMgr()) {
                this.setEmbeddedMgrInProxy(true);
                this.setEmbeddedMgrProxySideInstance(true);
            }
        } else {
            this.setEmbeddedMgrInProxy(true);
            this.setEmbeddedMgrProxySideInstance(true);
        }
    }

    public long getLease() {
        return this.lease;
    }

    public void setLease(long lease) {
        this.lease = lease;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ServerTransaction)) {
            return false;
        }
        ServerTransaction t = (ServerTransaction)other;
        return this.id == t.id && this.mgr.equals(t.mgr);
    }

    public int hashCode() {
        return (int)this.id ^ this.mgr.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", manager=" + this.mgr + "]";
    }

    @Override
    public void commit() throws UnknownTransactionException, CannotCommitException, RemoteException {
        try {
            this.mgr.commit(this.id, Long.MAX_VALUE);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
    }

    @Override
    public void commit(long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        this.mgr.commit(this.id, waitFor);
    }

    @Override
    public void abort() throws UnknownTransactionException, CannotAbortException, RemoteException {
        try {
            this.mgr.abort(this.id, Long.MAX_VALUE);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
    }

    @Override
    public void abort(long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        this.mgr.abort(this.id, waitFor);
    }

    public void join(TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (crashCount == Long.MAX_VALUE) {
            this.mgr.join(this.id, part, crashCount, this);
        } else {
            this.mgr.join(this.id, part, crashCount);
        }
    }

    protected void join(TransactionParticipant part, long crashCount, int partitionId, String clusterName, Object proxy) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (crashCount != Long.MAX_VALUE) {
            throw new UnsupportedOperationException(" supported only for embedded join");
        }
        this.mgr.join(this.id, part, crashCount, this, partitionId, clusterName, proxy);
    }

    public void join(TransactionParticipant part, long crashCount, int partitionId, String clusterName) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (crashCount == Long.MAX_VALUE) {
            throw new UnsupportedOperationException(" not supported for embedded join");
        }
        this.mgr.join(this.id, part, crashCount, partitionId, clusterName);
    }

    public int getState() throws UnknownTransactionException, RemoteException {
        return this.mgr.getState(this.id);
    }

    public boolean isNested() {
        return false;
    }

    public TransactionParticipantDataImpl getMetaData() {
        return this.metaData;
    }

    public void setMetaData(TransactionParticipantDataImpl metaData) {
        this.metaData = metaData;
    }

    @Override
    public boolean isEmbeddedMgrInProxy() {
        return this._embeddedMgrInProxy;
    }

    private void setEmbeddedMgrInProxy(boolean value) {
        this._embeddedMgrInProxy = value;
    }

    public boolean isEmbeddedMgrProxySideInstance() {
        return this._embeddedMgrProxySideInstance;
    }

    public void setEmbeddedMgrProxySideInstance(boolean value) {
        this._embeddedMgrProxySideInstance = value;
    }

    @Override
    public boolean needParticipantsJoin() throws RemoteException {
        return this.mgr.needParticipantsJoin();
    }

    public boolean isXid() {
        return false;
    }

    protected ServerTransaction createInstance() {
        return new ServerTransaction();
    }

    public ServerTransaction createCopy() {
        ServerTransaction other = this.createInstance();
        other.mgr = this.mgr;
        other.id = this.id;
        other.lease = this.lease;
        other._embeddedMgrInProxy = this._embeddedMgrInProxy;
        other._embeddedMgrProxySideInstance = this._embeddedMgrProxySideInstance;
        other.metaData = this.metaData;
        return other;
    }

    @Deprecated
    public void joinIfNeededAndEmbedded(TransactionParticipant participant) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (this.isEmbeddedMgrProxySideInstance() && this.needParticipantsJoin()) {
            this.join(participant, Long.MAX_VALUE);
        }
    }

    public boolean joinIfNeededAndEmbedded(TransactionParticipant participant, int partitionId, String clusterName, Object proxy) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (this.isEmbeddedMgrProxySideInstance() && this.needParticipantsJoin()) {
            if (partitionId < 0) {
                this.join(participant, Long.MAX_VALUE);
            } else {
                this.join(participant, Long.MAX_VALUE, partitionId, clusterName, proxy);
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    private void serialize(ObjectOutput out) throws IOException {
        boolean lightMgr;
        boolean bl = lightMgr = this._embeddedMgrProxySideInstance && this.needParticipantsJoin() && this.mgr instanceof TxnMgrProxy;
        if (lightMgr) {
            TxnMgrProxy cur = (TxnMgrProxy)this.mgr;
            out.writeObject(cur.createLightProxy());
        } else {
            out.writeObject(this.mgr);
        }
        out.writeLong(this.id);
        out.writeLong(this.lease);
        out.writeBoolean(this._embeddedMgrProxySideInstance);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    private final void deserialize(ObjectInput in) throws ClassNotFoundException, IOException {
        this.mgr = (ExtendedTransactionManager)in.readObject();
        this.id = in.readLong();
        this.lease = in.readLong();
        this._embeddedMgrInProxy = in.readBoolean();
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    public ExtendedTransactionManager getTransactionManager() {
        return this.mgr;
    }
}

