/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.transaction.server;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.export.UseStubCache;
import net.jini.id.Uuid;

public interface TransactionManager
extends Remote,
TransactionConstants {
    public Created create(long var1) throws LeaseDeniedException, RemoteException;

    public boolean needParticipantsJoin() throws RemoteException;

    @UseStubCache
    public void join(long var1, TransactionParticipant var3, long var4) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException;

    public int getState(long var1) throws UnknownTransactionException, RemoteException;

    public void commit(long var1) throws UnknownTransactionException, CannotCommitException, RemoteException;

    public void commit(long var1, long var3) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException;

    public void abort(long var1) throws UnknownTransactionException, CannotAbortException, RemoteException;

    public void abort(long var1, long var3) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException;

    public Uuid getTransactionManagerId() throws RemoteException;

    public static class Created
    implements Serializable {
        static final long serialVersionUID = -4233846033773471113L;
        public final long id;
        public final Lease lease;

        public Created(long id, Lease lease) {
            this.id = id;
            this.lease = lease;
        }

        public String toString() {
            return this.getClass().getName() + "[lease=" + this.lease + ", id=" + this.id + "]";
        }
    }
}

