/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.transaction.server;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationParticipantsMetadata;
import com.gigaspaces.internal.transaction.DefaultTransactionUniqueId;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.transaction.ConsolidatedDistributedTransactionMetaData;
import com.gigaspaces.transaction.TransactionParticipantMetaData;
import com.gigaspaces.transaction.TransactionUniqueId;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.transaction.server.TransactionParticipantData;

@InternalApi
public class TransactionParticipantDataImpl
implements TransactionParticipantData,
TransactionParticipantMetaData,
ConsolidatedDistributedTransactionMetaData,
Externalizable,
IReplicationParticipantsMetadata {
    static final long serialVersionUID = 1L;
    private int _participantId;
    private int _participantsCount;
    private TransactionUniqueId _transactionUniqueId;

    public TransactionParticipantDataImpl() {
    }

    public TransactionParticipantDataImpl(TransactionUniqueId transactionUniqueId, int partitionIdOneBased, int numberOfParticipants) {
        this._transactionUniqueId = transactionUniqueId;
        this._participantId = partitionIdOneBased;
        this._participantsCount = numberOfParticipants;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in, LRMIInvocationContext.getEndpointLogicalVersion());
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in, PlatformLogicalVersion.getLogicalVersion());
    }

    private void deserialize(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        this._transactionUniqueId = (TransactionUniqueId)in.readObject();
        this._participantId = in.readInt();
        this._participantsCount = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out, LRMIInvocationContext.getEndpointLogicalVersion());
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        this.serialize(out, PlatformLogicalVersion.getLogicalVersion());
    }

    private final void serialize(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        out.writeObject(this._transactionUniqueId);
        out.writeInt(this._participantId);
        out.writeInt(this._participantsCount);
    }

    @Override
    public long getTransactionId() {
        if (this._transactionUniqueId instanceof DefaultTransactionUniqueId) {
            return ((DefaultTransactionUniqueId)this._transactionUniqueId).getTransactionId();
        }
        return -1L;
    }

    @Override
    public TransactionUniqueId getTransactionUniqueId() {
        return this._transactionUniqueId;
    }

    @Override
    public int getParticipantId() {
        return this._participantId;
    }

    @Override
    public int getTransactionParticipantsCount() {
        return this._participantsCount;
    }

    public boolean isUnconsoliated() {
        return this._participantsCount > 1 && this._participantId != -1;
    }

    public String toString() {
        return "DistributedTransactionMetaData [getTransactionUniqueId()=" + this.getContextId() + ", getParticipantId()=" + this.getParticipantId() + ", getParticipantsCount()=" + this.getTransactionParticipantsCount() + "]";
    }

    @Override
    public Object getContextId() {
        return this.getTransactionUniqueId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._participantId;
        result = 31 * result + this._participantsCount;
        result = 31 * result + (this._transactionUniqueId == null ? 0 : this._transactionUniqueId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionParticipantDataImpl other = (TransactionParticipantDataImpl)obj;
        if (this._participantId != other._participantId) {
            return false;
        }
        if (this._participantsCount != other._participantsCount) {
            return false;
        }
        return !(this._transactionUniqueId == null ? other._transactionUniqueId != null : !this._transactionUniqueId.equals(other._transactionUniqueId));
    }
}

