/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.gigaspaces.api.InternalApi;
import java.net.InetAddress;
import java.net.UnknownHostException;

@InternalApi
public class Constants {
    private static final boolean multicastEnabled = Boolean.valueOf(System.getProperty("com.gs.multicast.enabled", "true"));
    private static final int multicastDiscoveryPort = Integer.getInteger("com.gs.multicast.discoveryPort", 4174);
    private static final int multicastTtl = Integer.getInteger("com.gs.multicast.ttl", 3);
    private static final String requestAddressProperty = System.getProperty("com.gs.multicast.request", "224.0.1.187");
    private static final String announcementAddressProperty = System.getProperty("com.gs.multicast.announcement", "224.0.1.188");
    private static final boolean useSocketKeepAlive = Boolean.parseBoolean(System.getProperty("com.gs.discovery.useSocketKeepAlive", "true"));
    private static final boolean useTcpNoDelay = Boolean.parseBoolean(System.getProperty("com.gs.discovery.useSocketTcpNoDelay", "true"));
    private static InetAddress requestAddress = null;
    private static InetAddress announcementAddress = null;

    private Constants() {
    }

    public static InetAddress getRequestAddress() throws UnknownHostException {
        if (requestAddress == null) {
            requestAddress = InetAddress.getByName(requestAddressProperty);
        }
        return requestAddress;
    }

    public static InetAddress getAnnouncementAddress() throws UnknownHostException {
        if (announcementAddress == null) {
            announcementAddress = InetAddress.getByName(announcementAddressProperty);
        }
        return announcementAddress;
    }

    public static int getDiscoveryPort() {
        return multicastDiscoveryPort;
    }

    public static int getTtl() {
        return multicastTtl;
    }

    public static boolean isMulticastEnabled() {
        return multicastEnabled;
    }

    public static boolean useSocketKeepAlive() {
        return useSocketKeepAlive;
    }

    public static boolean useSocketTcpNoDelay() {
        return useTcpNoDelay;
    }
}

