/*
 * Decompiled with CFR 0.152.
 */
package net.jini.export;

import com.sun.jini.resource.Service;
import java.rmi.server.ServerNotActiveException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.jini.security.Security;

public final class ServerContext {
    private static final ThreadLocal state = new ThreadLocal();
    private static final Spi[] providers = (Spi[])Security.doPrivileged(new PrivilegedAction(){

        public Object run() {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            ArrayList list = new ArrayList(1);
            Iterator i = Service.providers(Spi.class, cl);
            while (i.hasNext()) {
                list.add(i.next());
            }
            return list.toArray(new Spi[list.size()]);
        }
    });

    private ServerContext() {
    }

    public static void doWithServerContext(Runnable runnable, Collection context) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        if (state.get() != null) {
            throw new IllegalStateException("context is already set for this thread");
        }
        state.set(context);
        try {
            runnable.run();
        }
        finally {
            state.set(null);
        }
    }

    public static Collection getServerContext() throws ServerNotActiveException {
        Collection context = (Collection)state.get();
        if (context == null) {
            for (int i = 0; i < providers.length && (context = providers[i].getServerContext()) == null; ++i) {
            }
        }
        if (context == null) {
            throw new ServerNotActiveException("not in remote call");
        }
        return context;
    }

    public static Object getServerContextElement(Class type) throws ServerNotActiveException {
        Collection context = ServerContext.getServerContext();
        for (Object elem : context) {
            if (elem == null || !type.isAssignableFrom(elem.getClass())) continue;
            return elem;
        }
        return null;
    }

    public static interface Spi {
        public Collection getServerContext();
    }
}

