/*
 * Decompiled with CFR 0.152.
 */
package net.jini.io;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.server.RMIClassLoader;
import java.util.Collection;
import net.jini.io.ObjectStreamContext;

@InternalApi
public class MarshalOutputStream
extends ObjectOutputStream
implements ObjectStreamContext {
    private static final boolean USE_CODE_BASE = Boolean.getBoolean("net.jini.io.useCodeBase");
    private final Collection context;

    public MarshalOutputStream(OutputStream out, Collection context) throws IOException {
        super(out);
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    @Override
    public Collection getObjectStreamContext() {
        return this.context;
    }

    protected void annotateClass(Class cl) throws IOException {
        this.writeAnnotation(this.getAnnotation(cl));
    }

    protected void annotateProxyClass(Class cl) throws IOException {
        this.writeAnnotation(this.getAnnotation(cl));
    }

    protected void writeAnnotation(String annotation) throws IOException {
        this.writeObject(annotation);
    }

    private String getAnnotation(Class cl) {
        return USE_CODE_BASE ? RMIClassLoader.getClassAnnotation(cl) : null;
    }
}

