/*
 * Decompiled with CFR 0.152.
 */
package net.jini.io;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.MarshalledObject;
import net.jini.io.OptimizedByteArrayInputStream;
import net.jini.io.OptimizedByteArrayOutputStream;
import net.jini.io.context.IntegrityEnforcement;

@InternalApi
public class MarshalledInstance
implements Serializable {
    public static final String USE_GZIP_PROPERTY = "com.gs.lookup.useGzip";
    private static final boolean USE_GZIP = System.getProperty("com.gs.lookup.useGzip", "false").equalsIgnoreCase("true");
    private byte[] objBytes = null;
    private byte[] locBytes = null;
    private int hash;
    static final long serialVersionUID = -5187033771082433496L;

    public MarshalledInstance(Object obj) throws IOException {
        this(obj, Collections.EMPTY_SET);
    }

    public MarshalledInstance(Object obj, Collection context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (obj == null) {
            this.hash = 13;
            return;
        }
        OptimizedByteArrayOutputStream bByteOut = new OptimizedByteArrayOutputStream();
        bByteOut.writeByte(this.buildFlag());
        OptimizedByteArrayOutputStream lByteOut = new OptimizedByteArrayOutputStream();
        lByteOut.writeByte(this.buildFlag());
        OutputStream bout = bByteOut;
        if (USE_GZIP) {
            bout = new GZIPOutputStream(bout);
        }
        OutputStream lout = lByteOut;
        if (USE_GZIP) {
            lout = new GZIPOutputStream(lout);
        }
        MarshalledInstanceOutputStream out = new MarshalledInstanceOutputStream(bout, lout, context);
        out.writeObject(obj);
        out.flush();
        bout.close();
        lout.close();
        this.objBytes = bByteOut.toByteArray();
        this.locBytes = out.hadAnnotations() ? lByteOut.toByteArray() : null;
        int h = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            h = 31 * h + this.objBytes[i];
        }
        this.hash = h;
    }

    public MarshalledInstance(java.rmi.MarshalledObject mo) {
        if (mo == null) {
            throw new NullPointerException();
        }
        MarshalledObject privateMO = null;
        try {
            OptimizedByteArrayOutputStream baos = new OptimizedByteArrayOutputStream();
            baos.writeByte(this.buildFlag());
            OutputStream os = baos;
            if (USE_GZIP) {
                os = new GZIPOutputStream(os);
            }
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(mo);
            oos.flush();
            os.close();
            byte[] bytes = baos.toByteArray();
            OptimizedByteArrayInputStream bais = new OptimizedByteArrayInputStream(bytes);
            byte flags = bais.readByte();
            InputStream is = bais;
            if (this.isGzip(flags)) {
                is = new GZIPInputStream(is);
            }
            FromMOInputStream ois = new FromMOInputStream(is);
            privateMO = (MarshalledObject)ois.readObject();
            is.close();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
        this.objBytes = privateMO.objBytes;
        this.locBytes = privateMO.locBytes;
        this.hash = privateMO.hash;
    }

    public java.rmi.MarshalledObject convertToMarshalledObject() {
        MarshalledObject privateMO = new MarshalledObject();
        privateMO.objBytes = this.objBytes;
        privateMO.locBytes = this.locBytes;
        privateMO.hash = this.hash;
        java.rmi.MarshalledObject mo = null;
        try {
            OptimizedByteArrayOutputStream baos = new OptimizedByteArrayOutputStream();
            baos.writeByte(this.buildFlag());
            OutputStream os = baos;
            if (USE_GZIP) {
                os = new GZIPOutputStream(baos);
            }
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(privateMO);
            oos.flush();
            os.close();
            byte[] bytes = baos.toByteArray();
            OptimizedByteArrayInputStream bais = new OptimizedByteArrayInputStream(bytes);
            byte flags = bais.readByte();
            InputStream is = bais;
            if (this.isGzip(flags)) {
                is = new GZIPInputStream(is);
            }
            ToMOInputStream ois = new ToMOInputStream(is);
            mo = (java.rmi.MarshalledObject)ois.readObject();
            is.close();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
        return mo;
    }

    public Object get(boolean verifyCodebaseIntegrity) throws IOException, ClassNotFoundException {
        return this.get(null, verifyCodebaseIntegrity, null, null);
    }

    public Object get(ClassLoader defaultLoader, final boolean verifyCodebaseIntegrity, ClassLoader verifierLoader, Collection context) throws IOException, ClassNotFoundException {
        byte flags;
        if (this.objBytes == null) {
            return null;
        }
        if (context == null) {
            context = Collections.singleton(new IntegrityEnforcement(){

                @Override
                public boolean integrityEnforced() {
                    return verifyCodebaseIntegrity;
                }
            });
        }
        OptimizedByteArrayInputStream bin = new OptimizedByteArrayInputStream(this.objBytes);
        byte bflags = bin.readByte();
        InputStream bis = bin;
        if (this.isGzip(bflags)) {
            bis = new GZIPInputStream(bis);
        }
        OptimizedByteArrayInputStream lin = this.locBytes == null ? null : new OptimizedByteArrayInputStream(this.locBytes);
        InputStream lis = lin;
        if (lin != null && this.isGzip(flags = lin.readByte())) {
            lis = new GZIPInputStream(lis);
        }
        MarshalledInstanceInputStream in = new MarshalledInstanceInputStream(bis, lis, defaultLoader, verifyCodebaseIntegrity, verifierLoader, context);
        in.useCodebaseAnnotations();
        Object obj = in.readObject();
        in.close();
        bis.close();
        if (lis != null) {
            lis.close();
        }
        return obj;
    }

    public boolean fullyEquals(Object obj) {
        if (this.equals(obj)) {
            MarshalledInstance other = (MarshalledInstance)obj;
            return Arrays.equals(this.locBytes, other.locBytes);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MarshalledInstance) {
            MarshalledInstance other = (MarshalledInstance)obj;
            if (this.hash != other.hash) {
                return false;
            }
            return Arrays.equals(this.objBytes, other.objBytes);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.objBytes == null && (this.hash != 13 || this.locBytes != null)) {
            throw new InvalidObjectException("Bad hash or annotation");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Bad class hierarchy");
    }

    private byte buildFlag() {
        byte flags = 0;
        if (USE_GZIP) {
            flags = (byte)(flags | 1);
        }
        return flags;
    }

    private boolean isGzip(byte flags) {
        return (flags & 1) != 0;
    }

    private static class ToMOInputStream
    extends ObjectInputStream {
        public ToMOInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (desc.getName().equals("net.jini.io.MarshalledObject")) {
                return java.rmi.MarshalledObject.class;
            }
            return super.resolveClass(desc);
        }
    }

    private static class FromMOInputStream
    extends ObjectInputStream {
        public FromMOInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (desc.getName().equals("java.rmi.MarshalledObject")) {
                return MarshalledObject.class;
            }
            return super.resolveClass(desc);
        }
    }

    private static class MarshalledInstanceInputStream
    extends MarshalInputStream {
        private ObjectInputStream locIn;

        MarshalledInstanceInputStream(InputStream objIn, InputStream locIn, ClassLoader defaultLoader, boolean verifyCodebaseIntegrity, ClassLoader verifierLoader, Collection context) throws IOException {
            super(objIn, defaultLoader, verifyCodebaseIntegrity, verifierLoader, context);
            this.locIn = locIn == null ? null : new ObjectInputStream(locIn);
        }

        @Override
        protected String readAnnotation() throws IOException, ClassNotFoundException {
            return this.locIn == null ? null : (String)this.locIn.readObject();
        }
    }

    private static class MarshalledInstanceOutputStream
    extends MarshalOutputStream {
        private ObjectOutputStream locOut;
        private boolean hadAnnotations;

        public MarshalledInstanceOutputStream(OutputStream objOut, OutputStream locOut, Collection context) throws IOException {
            super(objOut, context);
            this.locOut = new ObjectOutputStream(locOut);
            this.hadAnnotations = false;
        }

        public boolean hadAnnotations() {
            return this.hadAnnotations;
        }

        @Override
        protected void writeAnnotation(String loc) throws IOException {
            this.hadAnnotations |= loc != null;
            this.locOut.writeObject(loc);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.locOut.flush();
        }
    }

    private static interface HeaderBitMap {
        public static final byte GZIP = 1;
    }
}

