/*
 * Decompiled with CFR 0.152.
 */
package net.jini.io;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@InternalApi
public class OptimizedByteArrayOutputStream
extends OutputStream {
    protected byte[] _buffer;
    protected int _count;

    public OptimizedByteArrayOutputStream() {
        this(32);
    }

    public OptimizedByteArrayOutputStream(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative initial size: " + capacity);
        }
        this._buffer = new byte[capacity];
    }

    public final void copyToBuffer(ByteBuffer buffer) {
        buffer.put(this._buffer, 0, this._count);
    }

    public void setBuffer(byte[] buf) {
        this.setBuffer(buf, 0);
    }

    public void setBuffer(byte[] buffer, int count) {
        this._buffer = buffer;
        this._count = count;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public void setSize(int size) {
        this._count = size;
    }

    public int size() {
        return this._count;
    }

    public int getCapacity() {
        return this._buffer.length;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(1);
        this._buffer[this._count++] = (byte)b;
    }

    public void writeByte(byte b) {
        this.ensureCapacity(1);
        this._buffer[this._count++] = b;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len);
        System.arraycopy(b, off, this._buffer, this._count, len);
        this._count += len;
    }

    public boolean ensureCapacity(int delta) {
        int newcount = this._count + delta;
        if (newcount > this._buffer.length) {
            byte[] newbuf = new byte[Math.max(this._buffer.length << 1, newcount)];
            System.arraycopy(this._buffer, 0, newbuf, 0, this._count);
            this._buffer = newbuf;
            return true;
        }
        return false;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buffer, 0, this._count);
    }

    public void reset() {
        this._count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this._count];
        System.arraycopy(this._buffer, 0, newbuf, 0, this._count);
        return newbuf;
    }
}

