/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.policy;

import com.gigaspaces.api.InternalApi;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import net.jini.security.GrantPermission;
import net.jini.security.policy.PolicyInitializationException;
import net.jini.security.policy.UmbrellaGrantPermission;

@InternalApi
public class PolicyFileProvider
extends Policy {
    private static final String basePolicyClassProperty = "net.jini.security.policy.PolicyFileProvider.basePolicyClass";
    private static final String defaultBasePolicyClass = "sun.security.provider.PolicyFile";
    private static final String policyProperty = "java.security.policy";
    private static final Object propertyLock = new Object();
    private final String policyFile;
    private final Policy basePolicy;

    public PolicyFileProvider() throws PolicyInitializationException {
        this.policyFile = null;
        String cname = Security.getProperty(basePolicyClassProperty);
        if (cname == null) {
            cname = defaultBasePolicyClass;
        }
        try {
            this.basePolicy = (Policy)Class.forName(cname).newInstance();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PolicyInitializationException("unable to construct base policy", e);
        }
        this.ensureDependenciesResolved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyFileProvider(String policyFile) throws PolicyInitializationException {
        if (policyFile == null) {
            throw new NullPointerException();
        }
        this.policyFile = policyFile;
        String cname = Security.getProperty(basePolicyClassProperty);
        if (cname == null) {
            cname = defaultBasePolicyClass;
        }
        try {
            Class<?> cl = Class.forName(cname);
            Object object = propertyLock;
            synchronized (object) {
                String oldp = System.getProperty(policyProperty);
                System.setProperty(policyProperty, policyFile);
                try {
                    this.basePolicy = (Policy)cl.newInstance();
                }
                finally {
                    PolicyFileProvider.resetPolicyProperty(oldp);
                }
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PolicyInitializationException("unable to construct base policy", e);
        }
        this.ensureDependenciesResolved();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource source) {
        PermissionCollection pc = this.basePolicy.getPermissions(source);
        PolicyFileProvider.expandUmbrella(pc);
        return pc;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection pc = this.basePolicy.getPermissions(domain);
        PolicyFileProvider.expandUmbrella(pc);
        return pc;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        return this.basePolicy.implies(domain, permission) || permission instanceof GrantPermission && this.getPermissions(domain).implies(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.policyFile != null) {
            Object object = propertyLock;
            synchronized (object) {
                String oldp = System.getProperty(policyProperty);
                System.setProperty(policyProperty, this.policyFile);
                try {
                    this.basePolicy.refresh();
                }
                finally {
                    PolicyFileProvider.resetPolicyProperty(oldp);
                }
            }
        }
        this.basePolicy.refresh();
    }

    private void ensureDependenciesResolved() {
        new GrantPermission(new UmbrellaGrantPermission());
    }

    private static void expandUmbrella(PermissionCollection pc) {
        if (pc.implies(new UmbrellaGrantPermission())) {
            ArrayList<Permission> l = Collections.list(pc.elements());
            pc.add(new GrantPermission(l.toArray(new Permission[l.size()])));
        }
    }

    private static void resetPolicyProperty(final String value) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (value == null) {
                    System.getProperties().remove(PolicyFileProvider.policyProperty);
                } else {
                    System.setProperty(PolicyFileProvider.policyProperty, value);
                }
                return null;
            }
        });
    }
}

