/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.proxytrust;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.security.Permission;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.Exporter;
import net.jini.security.Security;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ProxyTrustInvocationHandler;
import net.jini.security.proxytrust.ServerProxyTrust;
import net.jini.security.proxytrust.TrustEquivalence;

@InternalApi
public class ProxyTrustExporter
implements Exporter {
    private static final Permission loaderPermission = new RuntimePermission("getClassLoader");
    private static final Executor systemThreadPool = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
    private static final Set refs = new HashSet();
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static Reaper reaper = null;
    private final Exporter mainExporter;
    private final Exporter bootExporter;
    private final ClassLoader loader;
    private WeakRef ref = null;

    public ProxyTrustExporter(Exporter mainExporter, Exporter bootExporter) {
        this(mainExporter, bootExporter, null);
    }

    public ProxyTrustExporter(Exporter mainExporter, Exporter bootExporter, ClassLoader loader) {
        if (mainExporter == null || bootExporter == null) {
            throw new NullPointerException("exporter is null");
        }
        this.mainExporter = mainExporter;
        this.bootExporter = bootExporter;
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Remote export(Remote impl) throws ExportException {
        SecurityManager sm;
        if (impl != null && !(impl instanceof ServerProxyTrust)) {
            throw new IllegalArgumentException("must implement ServerProxyTrust");
        }
        if (this.loader == null && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(loaderPermission);
        }
        Remote main = this.mainExporter.export(impl);
        Class<?> c = main.getClass();
        LinkedList ifaces = new LinkedList();
        Remote boot = null;
        boolean ok = false;
        try {
            Class sup;
            if (!(main instanceof RemoteMethodControl)) {
                throw new ExportException("main proxy must implement RemoteMethodControl");
            }
            if (!(main instanceof TrustEquivalence)) {
                throw new ExportException("main proxy must implement TrustEquivalence");
            }
            boolean needPub = !Modifier.isPublic(c.getModifiers());
            for (sup = c; sup != null; sup = sup.getSuperclass()) {
                Class<?>[] ifs = sup.getInterfaces();
                int i = ifs.length;
                while (--i >= 0) {
                    if (needPub && !Modifier.isPublic(ifs[i].getModifiers())) {
                        throw new ExportException("main proxy implements non-public interface");
                    }
                    ifaces.remove(ifs[i]);
                    ifaces.addFirst(ifs[i]);
                }
            }
            this.ref = new WeakRef(impl);
            sup = refs;
            synchronized (sup) {
                if (reaper == null) {
                    reaper = new Reaper();
                    systemThreadPool.execute(reaper, "ProxyTrustExporter.Reaper");
                }
                refs.add(this.ref);
            }
            boot = this.bootExporter.export(this.ref.boot);
            if (!(boot instanceof ProxyTrust)) {
                throw new ExportException("bootstrap proxy must implement ProxyTrust");
            }
            if (!(boot instanceof RemoteMethodControl)) {
                throw new ExportException("bootstrap proxy must implement RemoteMethodControl");
            }
            if (!(boot instanceof TrustEquivalence)) {
                throw new ExportException("bootstrap proxy must implement TrustEquivalence");
            }
            Remote proxy = (Remote)Proxy.newProxyInstance(this.loader != null ? this.loader : c.getClassLoader(), ifaces.toArray(new Class[ifaces.size()]), (InvocationHandler)new ProxyTrustInvocationHandler((RemoteMethodControl)((Object)main), (ProxyTrust)boot));
            ok = true;
            Remote remote = proxy;
            return remote;
        }
        catch (IllegalArgumentException e) {
            throw new ExportException("export failed", e);
        }
        finally {
            if (!ok) {
                if (this.ref != null) {
                    this.ref.enqueue();
                }
                if (boot != null) {
                    this.bootExporter.unexport(true);
                }
                this.mainExporter.unexport(true);
            }
        }
    }

    @Override
    public synchronized boolean unexport(boolean force) {
        if (!this.mainExporter.unexport(force)) {
            return false;
        }
        this.bootExporter.unexport(true);
        if (this.ref != null) {
            this.ref.enqueue();
        }
        return true;
    }

    private static class ProxyTrustImpl
    implements ProxyTrust {
        private final Reference ref;

        ProxyTrustImpl(Reference ref) {
            this.ref = ref;
        }

        @Override
        public TrustVerifier getProxyVerifier() throws RemoteException {
            ServerProxyTrust impl = (ServerProxyTrust)this.ref.get();
            if (impl == null) {
                throw new UnsupportedOperationException("impl is gone");
            }
            return impl.getProxyVerifier();
        }
    }

    private static class Reaper
    implements Runnable {
        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    Reference ref = queue.remove();
                    ref.clear();
                    Set set = refs;
                    synchronized (set) {
                        refs.remove(ref);
                        if (refs.isEmpty()) {
                            reaper = null;
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static class WeakRef
    extends WeakReference {
        ProxyTrust boot = new ProxyTrustImpl(this);

        WeakRef(Remote impl) {
            super(impl, queue);
        }

        @Override
        public void clear() {
            super.clear();
            this.boot = null;
        }
    }
}

