/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.start.AggregatePolicyProvider;
import com.sun.jini.start.LoaderSplitPolicyProvider;
import com.sun.jini.start.SharedActivationPolicyPermission;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.ProxyAccessor;
import net.jini.security.policy.DynamicPolicyProvider;
import net.jini.security.policy.PolicyFileProvider;
import org.jini.rio.boot.ClassAnnotator;
import org.jini.rio.boot.CommonClassLoader;
import org.jini.rio.boot.ServiceClassLoader;

@InternalApi
public class ActivateWrapper
implements Remote,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String CONFIG_COMPONENT = "org.jini.rio.boot";
    static final Logger logger = Logger.getLogger("org.jini.rio.boot.wrapper");
    private static AggregatePolicyProvider globalPolicy;
    private static Policy initialGlobalPolicy;
    private Object impl;
    private static final Class[] actTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivateWrapper(ActivationID id, MarshalledObject data) throws Exception {
        logger.entering(ActivateWrapper.class.getName(), "ActivateWrapper", new Object[]{id, data});
        ActivateDesc desc = (ActivateDesc)data.get();
        logger.log(Level.FINEST, "ActivateDesc: {0}", desc);
        CommonClassLoader commonCL = CommonClassLoader.getInstance();
        commonCL.addCommonJARs(desc.commonJARs);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Created CommonClassLoader: {0}", commonCL);
        }
        ServiceClassLoader cl = null;
        try {
            cl = new ServiceClassLoader("active-wrapper", desc.importLocation, new ClassAnnotator(desc.exportLocation, new Properties()), commonCL);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Created ServiceClassLoader: {0}", cl);
            }
        }
        catch (Exception e) {
            logger.throwing(ActivateWrapper.class.getName(), "ActivateWrapper", e);
            throw e;
        }
        ActivateWrapper.checkPolicyPermission(desc.policy, desc.importLocation);
        Class<ActivateWrapper> e = ActivateWrapper.class;
        synchronized (ActivateWrapper.class) {
            if (globalPolicy == null) {
                initialGlobalPolicy = Policy.getPolicy();
                globalPolicy = new AggregatePolicyProvider(initialGlobalPolicy);
                Policy.setPolicy(globalPolicy);
                logger.log(Level.FINEST, "Global policy set: {0}", globalPolicy);
            }
            DynamicPolicyProvider service_policy = new DynamicPolicyProvider(new PolicyFileProvider(desc.policy));
            LoaderSplitPolicyProvider split_service_policy = new LoaderSplitPolicyProvider(cl, service_policy, new DynamicPolicyProvider(initialGlobalPolicy));
            split_service_policy.grant(this.getClass(), null, new Permission[]{new AllPermission()});
            globalPolicy.setPolicy(cl, split_service_policy);
            logger.log(Level.FINEST, "Added policy to set: {0}", desc.policy);
            // ** MonitorExit[e] (shouldn't be in output)
            Thread t = Thread.currentThread();
            ClassLoader ccl = t.getContextClassLoader();
            logger.log(Level.FINEST, "Saved current context class loader: {0}", ccl);
            t.setContextClassLoader(cl);
            logger.log(Level.FINEST, "Set new context class loader: {0}", cl);
            try {
                boolean initialize = false;
                Class<?> ac = Class.forName(desc.className, initialize, cl);
                logger.log(Level.FINEST, "Obtained implementation class: {0}", ac);
                Constructor<?> constructor = ac.getDeclaredConstructor(actTypes);
                logger.log(Level.FINEST, "Obtained implementation constructor: {0}", constructor);
                constructor.setAccessible(true);
                this.impl = constructor.newInstance(id, desc.data);
                logger.log(Level.FINEST, "Obtained implementation instance: {0}", this.impl);
            }
            finally {
                t.setContextClassLoader(ccl);
                logger.log(Level.FINEST, "Context class loader reset to: {0}", ccl);
            }
            logger.exiting(ActivateWrapper.class.getName(), "ActivateWrapper");
            return;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        Object impl_proxy = this.impl;
        if (this.impl instanceof ProxyAccessor) {
            impl_proxy = ((ProxyAccessor)this.impl).getProxy();
            logger.log(Level.FINEST, "Obtained implementation proxy: {0}", impl_proxy);
            if (impl_proxy == null) {
                throw new InvalidObjectException("Implementation's getProxy() returned null");
            }
        }
        return impl_proxy;
    }

    public static ActivationID register(ActivationGroupID gid, ActivateDesc desc, boolean restart, ActivationSystem sys) throws ActivationException, RemoteException {
        MarshalledObject<ActivateDesc> data;
        logger.entering(ActivateWrapper.class.getName(), "register", new Object[]{gid, desc, restart, sys});
        try {
            data = new MarshalledObject<ActivateDesc>(desc);
        }
        catch (Exception e) {
            MarshalException me = new MarshalException("marshalling ActivateDesc", e);
            logger.throwing(ActivateWrapper.class.getName(), "register", me);
            throw me;
        }
        ActivationDesc adesc = new ActivationDesc(gid, ActivateWrapper.class.getName(), null, data, restart);
        logger.log(Level.FINEST, "Registering descriptor with activation: {0}", adesc);
        ActivationID aid = sys.registerObject(adesc);
        logger.exiting(ActivateWrapper.class.getName(), "register", aid);
        return aid;
    }

    private static void checkPolicyPermission(String policy, URL[] urls) {
        logger.entering(ActivateWrapper.class.getName(), "checkPolicyPermission", new Object[]{policy, ActivateWrapper.urlsToPath(urls)});
        SharedActivationPolicyPermission perm = new SharedActivationPolicyPermission(policy);
        Certificate[] certs = null;
        CodeSource cs = null;
        ProtectionDomain pd = null;
        for (int i = 0; i < urls.length; ++i) {
            cs = new CodeSource(urls[i], certs);
            pd = new ProtectionDomain(cs, null, null, null);
            logger.log(Level.FINEST, "Checking protection domain: {0}", pd);
            if (pd.implies(perm)) continue;
            SecurityException se = new SecurityException("ProtectionDomain " + pd + " does not have required permission: " + perm);
            logger.throwing(ActivateWrapper.class.getName(), "checkPolicyPermission", se);
            throw se;
        }
        logger.exiting(ActivateWrapper.class.getName(), "checkPolicyPermission");
    }

    private static String urlsToPath(URL[] urls) {
        if (urls.length == 0) {
            return null;
        }
        if (urls.length == 1) {
            return urls[0].toExternalForm();
        }
        StringBuffer path = new StringBuffer(urls[0].toExternalForm());
        for (int i = 1; i < urls.length; ++i) {
            path.append(' ');
            path.append(urls[i].toExternalForm());
        }
        return path.toString();
    }

    static {
        actTypes = new Class[]{ActivationID.class, MarshalledObject.class};
    }

    public static class ActivateDesc
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String className;
        public final URL[] importLocation;
        public final URL[] exportLocation;
        public final URL[] commonJARs;
        public final String policy;
        public final MarshalledObject data;

        public ActivateDesc(String className, URL[] importLocation, URL[] exportLocation, URL[] commonJARs, String policy, MarshalledObject data) {
            this.className = className;
            this.importLocation = importLocation;
            this.exportLocation = exportLocation;
            this.commonJARs = commonJARs;
            this.policy = policy;
            this.data = data;
        }

        public String toString() {
            return "[className=" + this.className + ",importLocation=" + Arrays.asList(this.importLocation) + ",exportLocation=" + Arrays.asList(this.exportLocation) + ",policy=" + this.policy + ",data=" + this.data + "]";
        }
    }
}

