/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.start.ClasspathBuilder;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;

@InternalApi
public class BootUtil {
    private static final Logger LOGGER = Logger.getLogger(BootUtil.class.getName());
    private static final AtomicBoolean isLocalHostLoaded = new AtomicBoolean(false);
    private static NetworkInterface[] networkInterfaces;

    private BootUtil() {
        throw new AssertionError((Object)"org.jini.rio.boot.BootUtil cannot be instantiated");
    }

    public static String getCodebase(String[] jars, String protocol, String port) throws UnknownHostException {
        return BootUtil.getCodebase(jars, protocol, SystemInfo.singleton().network().getHostId(), port);
    }

    public static String getCodebase(String[] jars, String protocol, String address, String port) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < jars.length; ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(protocol + "://" + address + ":" + port + "/" + jars[i]);
        }
        return buffer.toString();
    }

    public static String getHostAddress() throws UnknownHostException {
        BootUtil.warmup();
        String value = System.getProperty("java.rmi.server.hostname");
        if (value == null) {
            InetAddress inetAddress = InetAddress.getLocalHost();
            value = BootIOUtils.wrapIpv6HostAddressIfNeeded(inetAddress);
        } else if (NetworkTuple.isNetworkTuple(value)) {
            NetworkTuple tuple = BootUtil.getNetworkSnapshot().parse(value);
            if (tuple.address == null) {
                throw new RuntimeException("Failed to find network interface for [" + value + "]");
            }
            value = tuple.host;
        } else {
            InetAddress inetAddress = InetAddress.getByName(value);
            value = BootUtil.toHostAddress(inetAddress, value);
        }
        System.setProperty("java.rmi.server.hostname", value);
        return value;
    }

    private static NetworkSnapshot getNetworkSnapshot() {
        try {
            return new NetworkSnapshot();
        }
        catch (SocketException e) {
            throw new IllegalStateException("Failed to get network information", e);
        }
    }

    private static String toHostAddress(InetAddress inetAddress, String value) {
        if (inetAddress instanceof Inet6Address && value.startsWith("[")) {
            return value;
        }
        String hostAddress = inetAddress.getHostAddress();
        if (value.equalsIgnoreCase(hostAddress)) {
            return hostAddress;
        }
        String canonicalHostName = inetAddress.getCanonicalHostName();
        if (value.equalsIgnoreCase(canonicalHostName)) {
            return canonicalHostName;
        }
        return inetAddress.getHostName();
    }

    public static String getAnonymousPort() throws IOException {
        return String.valueOf(BootUtil.getPort(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPort(int port) throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getPortInRange(int minPort, int maxPort) throws IOException {
        boolean MIN_PORT_LIMIT = true;
        int MAX_PORT_LIMIT = 65536;
        if (minPort < 0) {
            minPort = 1;
        }
        if (maxPort > 65536) {
            maxPort = 65536;
        }
        IOException ioEx = null;
        for (int i = minPort; i <= maxPort; ++i) {
            try {
                return String.valueOf(BootUtil.getPort(i));
            }
            catch (IOException ex) {
                ioEx = ex;
                continue;
            }
        }
        throw new IOException("Failed to get free port from supplied port range. minPort: " + minPort + " maxPort: " + maxPort + "Reason:" + ioEx);
    }

    public static int getAvailablePort(String hostname, String portRange) throws IOException {
        StringTokenizer st = new StringTokenizer(portRange, ",");
        while (st.hasMoreTokens()) {
            int index = portRange.indexOf(45);
            if (index == -1) {
                int port = Integer.parseInt(st.nextToken().trim());
                if (port == 0) {
                    return 0;
                }
                try {
                    return BootUtil.getPort(port);
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            int startPort = Integer.parseInt(portRange.substring(0, index));
            int endPort = Integer.parseInt(portRange.substring(index + 1));
            if (endPort < startPort) {
                throw new IllegalArgumentException("Start port [" + startPort + "] must be greater than end port [" + endPort + "]");
            }
            for (int i = startPort; i <= endPort; ++i) {
                try {
                    return BootUtil.getPort(i);
                }
                catch (IOException iOException) {
                    continue;
                }
            }
        }
        throw new IOException("Failed to get free port from [" + portRange + "]");
    }

    public static List<URL> toURLs(String element) throws MalformedURLException {
        return new ClasspathBuilder().append(element).toURLs();
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return BootUtil.arrayToDelimitedString(arr, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (arr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String[] toArray(String arg) {
        if (arg == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(arg, " ,");
        String[] array = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            array[i] = tok.nextToken();
            ++i;
        }
        return array;
    }

    public static LookupLocator[] toLookupLocators(String lookupLocatorURLs) {
        String locatorURL = null;
        ArrayList<LookupLocator> locatorList = new ArrayList<LookupLocator>();
        if (lookupLocatorURLs != null && lookupLocatorURLs.length() > 0) {
            StringTokenizer st = new StringTokenizer(lookupLocatorURLs, ",");
            while (st.hasMoreTokens()) {
                try {
                    locatorURL = st.nextToken().trim();
                    if (locatorURL.length() == 0 || locatorURL.equals("\"\"")) continue;
                    if (!locatorURL.startsWith("jini://")) {
                        locatorURL = "jini://" + locatorURL;
                    }
                    LookupLocator lookupLocator = new LookupLocator(locatorURL);
                    locatorList.add(lookupLocator);
                }
                catch (MalformedURLException ex) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "Failed to parse list of LookupLocator URLs: " + locatorURL + " - " + ex.toString(), ex);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, locatorList.toString());
        }
        return locatorList.toArray(new LookupLocator[0]);
    }

    public static String toLookupLocatorURLs(LookupLocator[] lookupLocators, boolean removeProtocolPrefix) {
        if (removeProtocolPrefix) {
            StringBuilder sb = new StringBuilder();
            for (LookupLocator locator : lookupLocators) {
                sb.append(locator.getHost()).append(":").append(locator.getPort()).append(",");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        return BootUtil.arrayToCommaDelimitedString(lookupLocators);
    }

    public static String formatDuration(long duration) {
        return (double)duration / 1000.0 + "s";
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static synchronized NetworkInterface[] getNetworkInterfaces() throws SocketException {
        if (networkInterfaces == null) {
            NetworkInterface[] networkInterfaceArray;
            NetworkSnapshot networkSnapshot = BootUtil.getNetworkSnapshot();
            NetworkInterface defaultNic = networkSnapshot.getDefaultNic();
            if (defaultNic != null) {
                NetworkInterface[] networkInterfaceArray2 = new NetworkInterface[1];
                networkInterfaceArray = networkInterfaceArray2;
                networkInterfaceArray2[0] = defaultNic;
            } else {
                networkInterfaceArray = networkSnapshot.getNetworkInterfaces(true);
            }
            networkInterfaces = networkInterfaceArray;
        }
        return networkInterfaces;
    }

    private static void warmup() {
        if (!isLocalHostLoaded.getAndSet(true) && LOGGER.isLoggable(Level.FINE)) {
            block4: {
                LOGGER.fine("---Before local host initialization---");
                try {
                    InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, e.toString(), e);
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("---After local host initialization---");
            }
        }
    }

    public static URL getResourceURL(String name, String locatorBaseDir) {
        URL result;
        block10: {
            result = null;
            try {
                File file;
                int lastChar;
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                String onlyResourceName = (lastChar = name.lastIndexOf(47)) > -1 ? name.substring(lastChar + 1) : null;
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                if (contextClassLoader != null) {
                    result = BootUtil.getResourceURL(contextClassLoader, name, onlyResourceName);
                }
                if (result == null && (file = new File(name)).isFile() && file.exists()) {
                    result = file.toURI().toURL();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Going to load the resource <" + name + "> from the path: " + result);
                    }
                    if (result != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Load resource: [" + name + "] \n [ Returning result: " + result + " ] \n" + (LOGGER.isLoggable(Level.FINEST) ? BootUtil.getStackTrace(new Exception("Debugging stack trace only (can be ignored): ")) : ""));
                        }
                        return result;
                    }
                }
                if (result == null && locatorBaseDir != null) {
                    String path = null;
                    path = !locatorBaseDir.endsWith("/") && !name.startsWith("/") ? locatorBaseDir + "/" + name : locatorBaseDir + name;
                    File resource = new File(path);
                    if (resource.exists()) {
                        result = resource.toURI().toURL();
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block10;
                LOGGER.log(Level.FINE, "Failed to load resource: [" + name + "] ", e);
            }
        }
        return result;
    }

    private static URL getResourceURL(ClassLoader classLoader, String name, String onlyResourceName) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Going to load resource <" + name + "> from ClassLoader: " + classLoader.getClass().getName());
        }
        boolean searchedOnlyResourceName = false;
        URL result = classLoader.getResource(name);
        if (result == null && onlyResourceName != null) {
            searchedOnlyResourceName = true;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Going to load resource <" + onlyResourceName + "> from ClassLoader: " + classLoader.getClass().getName());
            }
            result = classLoader.getResource(onlyResourceName);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder classLoaderHierarchy = new StringBuilder("ClassLoader Hierarchy: ");
            for (ClassLoader tmpCL = classLoader; tmpCL != null; tmpCL = tmpCL.getParent()) {
                classLoaderHierarchy.append(tmpCL.getClass().toString()).append(" <-- ");
            }
            LOGGER.log(Level.FINE, "Load resource: [" + (searchedOnlyResourceName ? onlyResourceName : name) + "] Thread: [" + Thread.currentThread().getName() + "] using ClassLoader: [" + classLoader + "] \n [ " + classLoaderHierarchy.toString() + " ] \n [ Returning result: " + result + " ] \n" + (LOGGER.isLoggable(Level.FINEST) ? BootUtil.getStackTrace(new Exception("Debugging stack trace only (can be ignored): ")) : ""));
        }
        return result;
    }

    public static class NetworkTuple {
        public static final String WRAPPER = "#";
        private final String name;
        private final HostTranslationType hostType;
        private final InetAddress address;
        private final NetworkInterface networkInterface;
        private final String host;

        public NetworkTuple(String name, HostTranslationType hostType, NetworkSnapshot networkSnapshot) throws UnknownHostException {
            this.name = name;
            this.hostType = hostType;
            if (name.equals("local")) {
                this.address = InetAddress.getLocalHost();
                this.networkInterface = null;
            } else {
                boolean excludeLoopback = true;
                boolean excludeIPv4 = hostType == HostTranslationType.ip6;
                boolean excludeIPv6 = hostType != HostTranslationType.ip6;
                List<NetworkInterfaceWrapper> nics = networkSnapshot.findByName(name);
                NetworkInterface resultNic = null;
                InetAddress resultAddress = null;
                for (NetworkInterfaceWrapper nic : nics) {
                    InetAddress address = nic.findAddress(true, excludeIPv4, excludeIPv6);
                    if (address == null) continue;
                    resultNic = nic.networkInterface;
                    resultAddress = address;
                    break;
                }
                this.networkInterface = resultNic;
                this.address = resultAddress;
            }
            this.host = NetworkTuple.translateHost(this.address, hostType);
        }

        public static boolean isNetworkTuple(String s) {
            return s.startsWith(WRAPPER) && s.endsWith(WRAPPER);
        }

        private static String translateHost(InetAddress address, HostTranslationType hostType) {
            if (address == null) {
                return null;
            }
            if (hostType == null) {
                return BootIOUtils.wrapIpv6HostAddressIfNeeded(address);
            }
            switch (hostType) {
                case canonicalhost: {
                    return address.getCanonicalHostName();
                }
                case host: {
                    return address.getHostName();
                }
                case ip: 
                case ip6: {
                    return BootIOUtils.wrapIpv6HostAddressIfNeeded(address);
                }
            }
            throw new IllegalStateException("Unsupported host type: " + (Object)((Object)hostType));
        }
    }

    private static enum HostTranslationType {
        ip,
        ip6,
        host,
        canonicalhost;

    }

    public static class NetworkSnapshot {
        private final List<NetworkInterface> allNics = new ArrayList<NetworkInterface>();
        private final List<NetworkInterfaceWrapper> activeNics = new ArrayList<NetworkInterfaceWrapper>();

        public NetworkSnapshot() throws SocketException {
            Enumeration<NetworkInterface> nicsIterator = NetworkInterface.getNetworkInterfaces();
            if (nicsIterator != null) {
                while (nicsIterator.hasMoreElements()) {
                    NetworkInterface nic = nicsIterator.nextElement();
                    this.allNics.add(nic);
                    NetworkInterfaceWrapper wrapper = new NetworkInterfaceWrapper(nic);
                    if (wrapper.addresses.isEmpty()) continue;
                    this.activeNics.add(wrapper);
                }
            }
        }

        public List<NetworkInterfaceWrapper> findByName(String name) {
            ArrayList<NetworkInterfaceWrapper> result = new ArrayList<NetworkInterfaceWrapper>();
            for (NetworkInterfaceWrapper wrapper : this.activeNics) {
                if (!name.equals(wrapper.networkInterface.getName()) && !name.equals(wrapper.networkInterface.getDisplayName())) continue;
                result.add(wrapper);
            }
            return result;
        }

        public NetworkTuple parse(String value) throws UnknownHostException {
            int pos;
            if (NetworkTuple.isNetworkTuple(value)) {
                value = value.substring("#".length(), value.length() - "#".length());
            }
            String name = (pos = value.indexOf(58)) != -1 ? value.substring(0, pos) : value;
            String type = pos != -1 ? value.substring(pos + 1) : null;
            HostTranslationType hostType = type != null ? HostTranslationType.valueOf(type) : null;
            return new NetworkTuple(name, hostType, this);
        }

        public NetworkInterface[] getNetworkInterfaces(boolean activeOnly) {
            NetworkInterface[] result;
            if (activeOnly) {
                result = new NetworkInterface[this.activeNics.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = this.activeNics.get(i).networkInterface;
                }
            } else {
                result = this.allNics.toArray(new NetworkInterface[this.allNics.size()]);
            }
            return result;
        }

        public NetworkInterface getDefaultNic() {
            NetworkInterface result;
            block4: {
                result = null;
                String hostName = System.getProperty("java.rmi.server.hostname");
                if (hostName == null) {
                    // empty if block
                }
                if (hostName != null) {
                    try {
                        result = NetworkTuple.isNetworkTuple(hostName) ? this.parse(hostName).networkInterface : NetworkInterface.getByInetAddress(InetAddress.getByName(hostName));
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                        LOGGER.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            return result;
        }
    }

    public static class NetworkInterfaceWrapper {
        private final NetworkInterface networkInterface;
        private final List<InetAddress> addresses;

        public NetworkInterfaceWrapper(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            this.addresses = new ArrayList<InetAddress>();
            Enumeration<InetAddress> addressIterator = networkInterface.getInetAddresses();
            while (addressIterator.hasMoreElements()) {
                this.addresses.add(addressIterator.nextElement());
            }
        }

        public InetAddress findAddress(boolean excludeLoopback, boolean excludeIPv4, boolean excludeIPv6) {
            for (InetAddress address : this.addresses) {
                if (excludeLoopback && address.isLoopbackAddress() || excludeIPv4 && address instanceof Inet4Address || excludeIPv6 && address instanceof Inet6Address) continue;
                return address;
            }
            return null;
        }
    }
}

