/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import net.jini.loader.ClassAnnotation;

@InternalApi
public class ClassAnnotator
implements ClassAnnotation {
    private URL[] codebase;
    private String exportAnnotation;
    private Properties properties = new Properties();

    public ClassAnnotator(URL[] codebase, Properties props) {
        if (props != null) {
            this.properties.putAll((Map<?, ?>)props);
        }
        this.setAnnotationURLs(codebase);
    }

    public URL[] getURLs() {
        URL[] urls = null;
        if (this.codebase != null) {
            urls = new URL[this.codebase.length];
            System.arraycopy(this.codebase, 0, urls, 0, urls.length);
        }
        return urls;
    }

    public void setAnnotationURLs(URL[] urls) {
        this.codebase = urls;
        this.exportAnnotation = ClassAnnotator.urlsToPath(this.codebase);
    }

    @Override
    public String getClassAnnotation() {
        return this.exportAnnotation;
    }

    protected Properties getProperties() {
        return new Properties(this.properties);
    }

    public static String urlsToPath(URL[] urls) {
        if (urls.length == 0) {
            return "";
        }
        if (urls.length == 1) {
            return urls[0].toExternalForm();
        }
        StringBuffer path = new StringBuffer(urls[0].toExternalForm());
        for (int i = 1; i < urls.length; ++i) {
            path.append(' ');
            path.append(urls[i].toExternalForm());
        }
        return path.toString();
    }
}

