/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.boot.CodeChangeClassLoader;
import org.jini.rio.boot.RemoteClassLoaderInfo;
import org.jini.rio.boot.SpaceInstanceRemoteClassLoaderInfo;
import org.jini.rio.boot.SupportCodeChangeAnnotationContainer;

@InternalApi
public class CodeChangeClassLoadersManager {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.lrmi.classloading");
    private static CodeChangeClassLoadersManager codeChangeClassLoadersManagerOfSpaceInstance;
    private final ClassLoader defaultClassLoader;
    private final boolean supportCodeChange;
    private final int maxClassLoaders;
    private final ConcurrentHashMap<String, CodeChangeClassLoader> versionToClassLoadersMap;

    public CodeChangeClassLoadersManager(ClassLoader defaultClassLoader, boolean supportCodeChange, int maxClassLoaders) {
        this.defaultClassLoader = defaultClassLoader;
        this.supportCodeChange = supportCodeChange;
        this.maxClassLoaders = maxClassLoaders;
        this.versionToClassLoadersMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getCodeChangeClassLoader(SupportCodeChangeAnnotationContainer supportCodeChangeAnnotationContainer) {
        if (!this.supportCodeChange) {
            throw new UnsupportedOperationException("Task has supportCodeAnnotation but it is disabled by space");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Search for class-loader with version [" + supportCodeChangeAnnotationContainer.getVersion() + "] ");
        }
        if (supportCodeChangeAnnotationContainer.getVersion().isEmpty()) {
            CodeChangeClassLoader codeChangeClassLoader = new CodeChangeClassLoader(new URL[0], this.defaultClassLoader);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Created new class-loader for one time use. New class loader is " + codeChangeClassLoader);
            }
            return codeChangeClassLoader;
        }
        String classVersion = supportCodeChangeAnnotationContainer.getVersion();
        ClassLoader cachedClassLoader = this.versionToClassLoadersMap.get(classVersion);
        if (cachedClassLoader != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Found class-loader: " + cachedClassLoader + ", with version: " + classVersion);
            }
            return cachedClassLoader;
        }
        CodeChangeClassLoadersManager codeChangeClassLoadersManager = this;
        synchronized (codeChangeClassLoadersManager) {
            CodeChangeClassLoader tcl = this.versionToClassLoadersMap.get(classVersion);
            if (tcl != null) {
                return tcl;
            }
            return this.insertToMap(classVersion);
        }
    }

    private CodeChangeClassLoader insertToMap(String version) {
        if (this.versionToClassLoadersMap.size() == this.maxClassLoaders) {
            this.removeOldestClassLoader();
        }
        CodeChangeClassLoader codeChangeClassLoader = new CodeChangeClassLoader(new URL[0], this.defaultClassLoader);
        this.versionToClassLoadersMap.put(version, codeChangeClassLoader);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Added new class-loader [" + codeChangeClassLoader + "] for version [" + version + "]");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Class-loaders: " + this.versionToClassLoadersMap + " , max-class-loaders=[" + this.maxClassLoaders + "]");
        }
        return codeChangeClassLoader;
    }

    private void removeOldestClassLoader() {
        String oldestVersion = this.findOldestVersion();
        CodeChangeClassLoader removedCodeChangeClassLoader = this.versionToClassLoadersMap.remove(oldestVersion);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Limit of max-class-loaders=[" + this.maxClassLoaders + "] reached, removing oldest class-loader [" + removedCodeChangeClassLoader + "] for version [" + oldestVersion + "]");
        }
    }

    private String findOldestVersion() {
        long min = System.currentTimeMillis();
        String oldestVersion = null;
        for (Map.Entry<String, CodeChangeClassLoader> versionClassLoaderEntry : this.versionToClassLoadersMap.entrySet()) {
            String version = versionClassLoaderEntry.getKey();
            CodeChangeClassLoader codeChangeClassLoader = versionClassLoaderEntry.getValue();
            long classLoaderLoadTime = codeChangeClassLoader.getLoadTime();
            if (classLoaderLoadTime >= min) continue;
            min = classLoaderLoadTime;
            oldestVersion = version;
        }
        return oldestVersion;
    }

    public SpaceInstanceRemoteClassLoaderInfo createSpaceInstanceRemoteClassLoaderInfo() {
        return new SpaceInstanceRemoteClassLoaderInfo(new RemoteClassLoaderInfo(this.defaultClassLoader.toString()), this.createClassLoaderInfoMap(this.versionToClassLoadersMap), this.maxClassLoaders);
    }

    private HashMap<String, RemoteClassLoaderInfo> createClassLoaderInfoMap(ConcurrentHashMap<String, CodeChangeClassLoader> versionToClassLoaderMap) {
        HashMap<String, RemoteClassLoaderInfo> map = new HashMap<String, RemoteClassLoaderInfo>();
        for (Map.Entry<String, CodeChangeClassLoader> versionClassLoaderEntry : versionToClassLoaderMap.entrySet()) {
            String version = versionClassLoaderEntry.getKey();
            CodeChangeClassLoader codeChangeClassLoader = versionClassLoaderEntry.getValue();
            map.put(version, codeChangeClassLoader.createRemoteClassLoaderInfo());
        }
        return map;
    }

    public static void initInstance(ClassLoader defaultClassLoader, boolean supportCodeChange, int maxClassLoaders) {
        codeChangeClassLoadersManagerOfSpaceInstance = new CodeChangeClassLoadersManager(defaultClassLoader, supportCodeChange, maxClassLoaders);
    }

    public static CodeChangeClassLoadersManager getInstance() {
        return codeChangeClassLoadersManagerOfSpaceInstance;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public int getMaxClassLoaders() {
        return this.maxClassLoaders;
    }

    public ConcurrentHashMap<String, CodeChangeClassLoader> getVersionToClassLoadersMap() {
        return this.versionToClassLoadersMap;
    }

    public boolean isSupportCodeChange() {
        return this.supportCodeChange;
    }
}

