/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.classloader.CustomURLClassLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.boot.ServiceClassLoader;
import org.jini.rio.core.jsb.ComponentLoader;

@InternalApi
public class CommonClassLoader
extends CustomURLClassLoader
implements ComponentLoader {
    private static final String COMPONENT = "org.jini.rio.boot";
    private static Logger logger = Logger.getLogger("org.jini.rio.boot");
    private static Map components = new HashMap();
    private static ArrayList codebaseComponents = new ArrayList();
    private static CommonClassLoader instance;
    private volatile boolean disableSmartGetUrl = false;

    public void setDisableSmartGetUrl(boolean disableSmartGetUrl) {
        this.disableSmartGetUrl = disableSmartGetUrl;
    }

    private CommonClassLoader(ClassLoader parent) {
        super("CommonClassLoader", new URL[0], parent);
    }

    public static synchronized CommonClassLoader getInstance() {
        if (instance == null) {
            instance = new CommonClassLoader(ClassLoader.getSystemClassLoader());
        }
        return instance;
    }

    @Override
    public URL[] getURLs() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this;
        }
        URL[] urls = this.doGetURLs(cl);
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < urls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(urls[i].toExternalForm());
            }
            logger.log(Level.FINEST, "Context ClassLoader={0} URLs={1}", new Object[]{cl.toString(), buffer.toString()});
        }
        return urls;
    }

    @Override
    public URL[] getSearchPath() {
        return super.getURLs();
    }

    private URL[] doGetURLs(ClassLoader cl) {
        if (this.disableSmartGetUrl) {
            return super.getURLs();
        }
        URL[] urls = null;
        if (cl.equals(this)) {
            urls = super.getURLs();
        } else if (cl instanceof ServiceClassLoader) {
            ServiceClassLoader scl = (ServiceClassLoader)cl;
            urls = scl.getURLs();
        } else {
            urls = super.getURLs();
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testComponentExistence(String name) {
        boolean exists;
        block7: {
            exists = false;
            Map map = components;
            synchronized (map) {
                if (components.containsKey(name)) {
                    exists = true;
                }
            }
            if (!exists) {
                try {
                    this.loadClass(name);
                    exists = true;
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINEST)) break block7;
                    logger.finest("Failed to find class " + name);
                }
            }
        }
        return exists;
    }

    public void addCommonJARs(URL[] jars) {
        if (jars == null) {
            return;
        }
        for (int i = 0; i < jars.length; ++i) {
            if (this.hasURL(jars[i])) continue;
            this.addURL(jars[i]);
        }
    }

    void addCodebaseComponents(URL[] jars) {
        if (jars == null) {
            return;
        }
        for (int i = 0; i < jars.length; ++i) {
            if (codebaseComponents.contains(jars[i])) continue;
            codebaseComponents.add(jars[i]);
        }
        this.addCommonJARs(jars);
    }

    @Override
    public boolean testResourceExistence(String name) {
        return this.getResource(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(String name, URL[] urls) {
        boolean added = false;
        boolean toAdd = false;
        boolean toReplace = false;
        Map map = components;
        synchronized (map) {
            if (components.containsKey(name)) {
                URL[] fetched = (URL[])components.get(name);
                if (fetched.length == urls.length) {
                    for (int i = 0; i < fetched.length; ++i) {
                        if (fetched[i].equals(urls[i])) continue;
                        toReplace = true;
                        break;
                    }
                } else {
                    toReplace = true;
                }
            } else {
                toAdd = true;
            }
            if (toAdd || toReplace) {
                added = true;
                if (logger.isLoggable(Level.FINEST)) {
                    String action = toAdd ? "Adding" : "Replacing";
                    logger.finest(action + " Component " + name);
                }
                components.put(name, urls);
            } else if (logger.isLoggable(Level.FINEST)) {
                StringBuffer buffer = new StringBuffer();
                URL[] codebase = (URL[])components.get(name);
                for (int i = 0; i < codebase.length; ++i) {
                    if (i > 0) {
                        buffer.append(":");
                    }
                    buffer.append(codebase[i].toExternalForm());
                }
                logger.log(Level.FINEST, "Component " + name + " has already been registered with a codebase of " + buffer.toString());
            }
        }
        if (added) {
            for (int i = 0; i < urls.length; ++i) {
                if (this.hasURL(urls[i])) continue;
                this.addURL(urls[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        boolean registered = false;
        Map map = components;
        synchronized (map) {
            registered = components.containsKey(name);
        }
        if (!registered) {
            if (this.testComponentExistence(name)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Loading unregistered component " + name);
                }
            } else {
                throw new ClassNotFoundException("Unregistered component " + name);
            }
        }
        Class<?> component = this.loadClass(name);
        return component.newInstance();
    }

    private boolean hasURL(URL url) {
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].equals(url)) continue;
            return true;
        }
        return false;
    }
}

