/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jini.rio.boot.TLSUtils;

@InternalApi
public class PUZipUtils {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.zip");
    private static final Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadProcessingUnit(String deployURL, String puPath, File puFile) throws Exception {
        if (!puFile.exists()) {
            throw new FileNotFoundException("File " + puFile.getAbsolutePath() + " doesn't exist");
        }
        boolean deletePUFile = false;
        if (puFile.isDirectory() && puFile.getParent().endsWith("/templates")) {
            logger.finest("Skip upload of " + puFile + " - template file");
            return;
        }
        if (puFile.exists() && puFile.isDirectory()) {
            File zipPUFile = new File(System.getProperty("java.io.tmpdir") + File.separator + puPath + ".zip");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Zip directory [" + puFile.getAbsolutePath() + "] into [" + zipPUFile.getAbsolutePath() + "]");
            }
            PUZipUtils.zip(puFile, zipPUFile);
            puFile = zipPUFile;
            deletePUFile = true;
        }
        if (!(puFile.getName().endsWith(".zip") || puFile.getName().endsWith(".jar") || puFile.getName().endsWith(".war"))) {
            throw new IllegalArgumentException("File " + puFile.getAbsolutePath() + " should be one of: zip/jar/war");
        }
        if (puFile.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File " + puFile.getPath() + " is too big: " + puFile.length() + " bytes");
        }
        byte[] buffer = new byte[4098];
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Uploading [" + puPath + "] from [" + puFile.getPath() + "] to [" + deployURL + "]");
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(deployURL + puFile.getName()).openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Extract", "true");
        conn.setFixedLengthStreamingMode((int)puFile.length());
        try {
            conn.connect();
            BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(puFile));
            try {
                int byteCount = 0;
                int bytesRead = -1;
                while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                    byteCount += bytesRead;
                }
                ((OutputStream)out).flush();
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            int responseCode = conn.getResponseCode();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String line;
                StringBuffer sb = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                if (responseCode != 200 && responseCode != 201) {
                    throw new RuntimeException("Failed to upload file, response code [" + responseCode + "], response: " + sb.toString());
                }
            }
        }
        finally {
            conn.disconnect();
            if (deletePUFile) {
                puFile.delete();
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Upload of [" + puPath + "] completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long downloadProcessingUnit(String puName, URL url, File extractToTarget, File tempLocation) throws Exception {
        File tempFile = new File(tempLocation, puName.replace('\\', '/') + random.nextLong() + ".zip");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Downloading [" + puName + "] from [" + url.toString() + "] to [" + tempFile.getAbsolutePath() + "], extracted to [" + extractToTarget.getAbsolutePath() + "]");
        }
        long size = 0L;
        try {
            PUZipUtils.downloadProcessingUnit(url, tempFile, puName);
            size = tempFile.length();
            try {
                PUZipUtils.unzip(tempFile, extractToTarget);
            }
            catch (Exception e) {
                throw new DownloadProcessingUnitException("Failed to extract processing unit [" + puName + "] downloaded temp zip file from [" + tempFile.getAbsolutePath() + "] into [" + extractToTarget.getAbsolutePath() + "] zipfile size is " + size + " original download URL is " + url, e);
            }
        }
        finally {
            tempFile.delete();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadProcessingUnit(URL url, File target, String puName) throws DownloadProcessingUnitException {
        int responseCode;
        HttpURLConnection conn;
        TLSUtils.enableHttpsClient();
        try {
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new DownloadProcessingUnitException("Failed to connect to [" + url.toString() + "] in order to download processing unit [" + puName + "]", e);
        }
        conn.setRequestProperty("Package", "true");
        try {
            responseCode = conn.getResponseCode();
        }
        catch (IOException e) {
            try {
                conn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DownloadProcessingUnitException("Failed to read response code from [" + url.toString() + "] in order to download processing unit [" + puName + "]", e);
        }
        if (responseCode != 200 && responseCode != 201) {
            try {
                if (responseCode == 404) {
                    throw new DownloadProcessingUnitException("Processing Unit [" + puName + "] not found on server [" + url.toString() + "]");
                }
                StringBuilder sb = new StringBuilder();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                }
                catch (Exception reader) {
                    // empty catch block
                }
                throw new DownloadProcessingUnitException("Failed to connect/download (failure on the web server side) from  [" + url.toString() + "], response code [" + responseCode + "], response [" + sb.toString() + "]");
            }
            catch (Throwable throwable) {
                conn.disconnect();
                throw throwable;
            }
        }
        target.getParentFile().mkdirs();
        try {
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            FileOutputStream out = new FileOutputStream(target);
            try {
                int byteCount = 0;
                byte[] buffer = new byte[4098];
                int bytesRead = -1;
                while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                    byteCount += bytesRead;
                }
                out.flush();
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException byteCount) {}
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException byteCount) {}
            }
            conn.disconnect();
            RandomAccessFile ras = new RandomAccessFile(target, "rw");
            ras.getFD().sync();
            ras.close();
        }
        catch (IOException e) {
            throw new DownloadProcessingUnitException("Failed to read processing unit [" + puName + "] from [" + url.toString() + "] into [" + target.getAbsolutePath() + "]", e);
        }
        finally {
            try {
                conn.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long unzip(File targetZip, File dirToExtract) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unzipping file [" + targetZip.getAbsolutePath() + "] with size [" + targetZip.length() + "] to [" + dirToExtract.getAbsolutePath() + "]");
        }
        long totalSize = 0L;
        int bufferSize = 4098;
        byte[] data = new byte[4098];
        ZipFile zipFile = new ZipFile(targetZip);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) {
                File dir = new File(dirToExtract.getAbsolutePath() + "/" + entry.getName().replace('\\', '/'));
                for (int i = 0; i < 5; ++i) {
                    dir.mkdirs();
                }
                continue;
            }
            BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
            File file = new File(dirToExtract.getAbsolutePath() + "/" + entry.getName().replace('\\', '/'));
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Extracting zip entry [" + entry.getName() + "] with size [" + entry.getSize() + "] to [" + file.getAbsolutePath() + "]");
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 4098);
            while ((count = is.read(data, 0, 4098)) != -1) {
                totalSize += (long)count;
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            is.close();
            RandomAccessFile ras = new RandomAccessFile(file, "rw");
            try {
                ras.getFD().sync();
            }
            finally {
                try {
                    ras.close();
                }
                catch (Exception exception) {}
            }
        }
        zipFile.close();
        return totalSize;
    }

    public static void zip(File dir2zip, File zipFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        PUZipUtils.internalZipDir(dir2zip.getAbsolutePath(), dir2zip.getAbsolutePath(), zos);
        zos.close();
    }

    private static void internalZipDir(String baseDir2zip, String dir2zip, ZipOutputStream zos) throws IOException {
        File zipDir = new File(dir2zip);
        if (!zipDir.exists()) {
            throw new IllegalArgumentException("Directory to zip [" + zipDir.getAbsolutePath() + "] does not exists");
        }
        if (!zipDir.isDirectory()) {
            throw new IllegalArgumentException("Directory to zip [" + zipDir.getAbsolutePath() + "] is not a directory");
        }
        String[] dirList = zipDir.list();
        if (dirList == null) {
            return;
        }
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getAbsolutePath();
                PUZipUtils.internalZipDir(baseDir2zip, filePath, zos);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            String path = f.getAbsolutePath().substring(baseDir2zip.length() + 1);
            path = path.replace('\\', '/');
            ZipEntry anEntry = new ZipEntry(path);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Compressing zip entry [" + anEntry.getName() + "] with size [" + anEntry.getSize() + "] at [" + f.getAbsolutePath() + "]");
            }
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
            fis.close();
        }
    }

    public static class DownloadProcessingUnitException
    extends Exception {
        private static final long serialVersionUID = -8734985356212361134L;

        public DownloadProcessingUnitException(String message) {
            super(message);
        }

        public DownloadProcessingUnitException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

