/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jini.rio.boot.CodeChangeClassLoader;

public class RemoteClassLoaderInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String name;
    private long loadTime;

    public RemoteClassLoaderInfo() {
    }

    public RemoteClassLoaderInfo(String name) {
        this.name = name;
        this.loadTime = -1L;
    }

    public RemoteClassLoaderInfo(CodeChangeClassLoader codeChangeClassLoader) {
        this.name = codeChangeClassLoader.toString();
        this.loadTime = codeChangeClassLoader.getLoadTime();
    }

    public String getName() {
        return this.name;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeLong(this.loadTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.loadTime = in.readLong();
    }

    public String toString() {
        return "RemoteClassLoaderInfo{name='" + this.name + '\'' + (this.loadTime != -1L ? ", loadTime=" + this.loadTime : "") + '}';
    }
}

