/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.config.Config;
import com.sun.jini.start.ClassLoaderUtil;
import com.sun.jini.start.HTTPDStatus;
import com.sun.jini.start.ServiceProxyAccessor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.boot.ActivateWrapper;
import org.jini.rio.boot.RioServiceDescriptor;

@InternalApi
public class RioActivatableServiceDescriptor
extends RioServiceDescriptor {
    private final String sharedGroupLog;
    private final boolean restart;
    private final String host;
    private final int port;
    private static final String GROUP_COOKIE_FILE = "cookie";
    private static final Logger logger = RioServiceDescriptor.logger;

    public RioActivatableServiceDescriptor(String name, String codebase, String policy, String classpath, String implClassName, String sharedGroupLog, String[] serverConfigArgs, boolean restart) {
        this(name, codebase, policy, classpath, implClassName, sharedGroupLog, serverConfigArgs, restart, null, RioActivatableServiceDescriptor.getDefaultActivationSystemPort());
    }

    public RioActivatableServiceDescriptor(String name, String codebase, String policy, String classpath, String implClassName, String sharedGroupLog, String[] serverConfigArgs, boolean restart, String host, int port) {
        super(name, codebase, policy, classpath, implClassName, serverConfigArgs, null);
        if (sharedGroupLog == null) {
            throw new NullPointerException("Shared VM log cannot be null");
        }
        this.sharedGroupLog = sharedGroupLog;
        this.restart = restart;
        this.host = host == null ? "" : host;
        this.port = port <= 0 ? RioActivatableServiceDescriptor.getDefaultActivationSystemPort() : port;
    }

    public final String getSharedGroupLog() {
        return this.sharedGroupLog;
    }

    public final boolean getRestart() {
        return this.restart;
    }

    public final String getActivationSystemHost() {
        return this.host;
    }

    public final int getActivationSystemPort() {
        return this.port;
    }

    @Override
    public Object create(Configuration config) throws Exception {
        URL[] commonJARs;
        logger.entering(RioActivatableServiceDescriptor.class.getName(), "create", new Object[]{config});
        if (config == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        HTTPDStatus.httpdWarning(this.getCodebase());
        URL[] defaultCommonJARs = null;
        String rioHome = System.getProperty("RIO_HOME");
        if (rioHome == null) {
            defaultCommonJARs = new URL[]{};
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("RIO_HOME not defined, defaultCommonJARs set to zero-length array");
            }
        } else {
            File rio = new File(rioHome + File.separator + "lib" + File.separator + "rio.jar");
            defaultCommonJARs = new URL[]{rio.toURL()};
        }
        if ((commonJARs = (URL[])config.getEntry(COMPONENT, "commonJARs", URL[].class, defaultCommonJARs)).length == 0) {
            throw new RuntimeException("No commonJARs have been defined");
        }
        Created created = null;
        ActivationSystem sys = RioActivatableServiceDescriptor.getActivationSystem(this.getActivationSystemHost(), this.getActivationSystemPort(), config);
        ProxyPreparer activationIDPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT, "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        ProxyPreparer servicePreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT, "servicePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        HTTPDStatus.httpdWarning(this.getCodebase());
        ActivationGroupID gid = null;
        ActivationID aid = null;
        Object proxy = null;
        try {
            MarshalledObject<String[]> params = new MarshalledObject<String[]>(this.getServerConfigArgs());
            ActivateWrapper.ActivateDesc adesc = new ActivateWrapper.ActivateDesc(this.getImplClassName(), ClassLoaderUtil.getClasspathURLs(this.getClasspath()), ClassLoaderUtil.getCodebaseURLs(this.getCodebase()), commonJARs, this.getPolicy(), params);
            logger.finest("ActivateDesc: " + adesc);
            gid = RioActivatableServiceDescriptor.restoreGroupID(this.getSharedGroupLog());
            aid = ActivateWrapper.register(gid, adesc, this.getRestart(), sys);
            aid = (ActivationID)activationIDPreparer.prepareProxy(aid);
            proxy = aid.activate(true);
            if (proxy != null && (proxy = servicePreparer.prepareProxy(proxy)) instanceof ServiceProxyAccessor) {
                proxy = ((ServiceProxyAccessor)proxy).getServiceProxy();
                proxy = servicePreparer.prepareProxy(proxy);
            }
        }
        catch (Exception e) {
            try {
                if (aid != null) {
                    sys.unregisterObject(aid);
                }
            }
            catch (Exception ee) {
                logger.log(Level.FINEST, "Unable to unregister with activation system", ee);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ActivationException) {
                throw (ActivationException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            throw new RuntimeException("Unexpected Exception", e);
        }
        created = new Created(gid, aid, proxy);
        logger.exiting(RioActivatableServiceDescriptor.class.getName(), "create", created);
        return created;
    }

    static ActivationSystem getActivationSystem(String host, int port, Configuration config) throws ActivationException {
        if (config == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        ActivationSystem sys = null;
        String h = host == null ? "" : host;
        int p = port <= 0 ? RioActivatableServiceDescriptor.getDefaultActivationSystemPort() : port;
        try {
            sys = (ActivationSystem)Naming.lookup("//" + h + ":" + p + "/java.rmi.activation.ActivationSystem");
            ProxyPreparer activationSystemPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT, "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            sys = (ActivationSystem)activationSystemPreparer.prepareProxy(sys);
        }
        catch (Exception e) {
            throw new ActivationException("ActivationSystem @ " + host + ":" + port + " could not be obtained", (Throwable)e);
        }
        return sys;
    }

    static int getDefaultActivationSystemPort() {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction("java.rmi.activation.port", 1098));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ActivationGroupID restoreGroupID(String dir) throws IOException, ClassNotFoundException {
        File log = new File(dir);
        String absDir = log.getAbsolutePath();
        if (!log.exists() || !log.isDirectory()) {
            throw new IOException("Log directory [" + absDir + "] does not exist.");
        }
        File cookieFile = new File(log, GROUP_COOKIE_FILE);
        ActivationGroupID obj = null;
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(cookieFile)));
            MarshalledObject mo = (MarshalledObject)ois.readObject();
            obj = (ActivationGroupID)mo.get();
        }
        return obj;
    }

    @Override
    public String toString() {
        ArrayList<Object> fields = new ArrayList<Object>(10);
        fields.add(this.getCodebase());
        fields.add(this.getPolicy());
        fields.add(this.getClasspath());
        fields.add(this.getImplClassName());
        fields.add(Arrays.asList(this.getServerConfigArgs()));
        fields.add(this.getLifeCycle());
        fields.add(this.sharedGroupLog);
        fields.add(this.restart);
        fields.add(this.host);
        fields.add(new Integer(this.port));
        return fields.toString();
    }

    public static class Created {
        public final ActivationGroupID gid;
        public final ActivationID aid;
        public final Object proxy;

        public Created(ActivationGroupID gid, ActivationID aid, Object proxy) {
            this.gid = gid;
            this.aid = aid;
            this.proxy = proxy;
        }
    }
}

