/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.config.Config;
import com.sun.jini.start.AggregatePolicyProvider;
import com.sun.jini.start.ClassLoaderUtil;
import com.sun.jini.start.HTTPDStatus;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.start.LoaderSplitPolicyProvider;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.ServiceProxyAccessor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.export.ProxyAccessor;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.policy.DynamicPolicyProvider;
import net.jini.security.policy.PolicyFileProvider;
import org.jini.rio.boot.ClassAnnotator;
import org.jini.rio.boot.CommonClassLoader;
import org.jini.rio.boot.ServiceClassLoader;

@InternalApi
public class RioServiceDescriptor
implements ServiceDescriptor {
    static String COMPONENT = "org.jini.rio.boot";
    static Logger logger = Logger.getLogger(COMPONENT);
    private static final Class[] actTypes = new Class[]{String[].class, LifeCycle.class};
    private String name;
    private String codebase;
    private String policy;
    private String classpath;
    private String implClassName;
    private String[] serverConfigArgs;
    private LifeCycle lifeCycle;
    private static LifeCycle NoOpLifeCycle = new LifeCycle(){

        @Override
        public boolean unregister(Object impl) {
            return false;
        }
    };
    private static AggregatePolicyProvider globalPolicy = null;
    private static Policy initialGlobalPolicy = null;

    public static AggregatePolicyProvider getGlobalPolicy() {
        return globalPolicy;
    }

    public RioServiceDescriptor(String name, String codebase, String policy, String classpath, String implClassName, String[] serverConfigArgs, LifeCycle lifeCycle) {
        if (codebase == null || classpath == null || implClassName == null) {
            throw new NullPointerException("Codebase, classpath, and implementation cannot be null");
        }
        this.name = name;
        this.codebase = codebase;
        this.policy = policy;
        this.classpath = classpath;
        this.implClassName = implClassName;
        this.serverConfigArgs = serverConfigArgs;
        this.lifeCycle = lifeCycle == null ? NoOpLifeCycle : lifeCycle;
    }

    public RioServiceDescriptor(String name, String codebase, String classpath, String implClassName, String[] serverConfigArgs) {
        this(name, codebase, System.getProperty("java.security.policy"), classpath, implClassName, serverConfigArgs, null);
    }

    public String getCodebase() {
        return this.codebase;
    }

    public String getPolicy() {
        return this.policy;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getImplClassName() {
        return this.implClassName;
    }

    public String[] getServerConfigArgs() {
        return this.serverConfigArgs != null ? (String[])this.serverConfigArgs.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object create(Configuration config) throws Exception {
        Object proxy = null;
        if (logger.isLoggable(Level.FINEST)) {
            HTTPDStatus.httpdWarning(this.getCodebase());
        }
        URL[] defaultCommonJARs = null;
        String rioHome = System.getProperty("RIO_HOME");
        if (rioHome == null) {
            defaultCommonJARs = new URL[]{};
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("RIO_HOME not defined, defaultCommonJARs set to zero-length array");
            }
        } else {
            File rio = new File(rioHome + File.separator + "lib" + File.separator + "rio.jar");
            defaultCommonJARs = new URL[]{rio.toURL()};
        }
        URL[] commonJARs = (URL[])config.getEntry(COMPONENT, "commonJARs", URL[].class, defaultCommonJARs);
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < commonJARs.length; ++i) {
                if (i > 0) {
                    buffer.append("\n");
                }
                buffer.append(commonJARs[i].toExternalForm());
            }
            logger.finest("commonJARs=\n" + buffer.toString());
        }
        CommonClassLoader commonCL = CommonClassLoader.getInstance();
        commonCL.addCommonJARs(commonJARs);
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        ClassAnnotator annotator = new ClassAnnotator(ClassLoaderUtil.getCodebaseURLs(this.getCodebase()), new Properties());
        ServiceClassLoader jsbCL = new ServiceClassLoader(this.name, ClassLoaderUtil.getClasspathURLs(this.getClasspath()), annotator, commonCL);
        currentThread.setContextClassLoader(jsbCL);
        ProxyPreparer servicePreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT, "servicePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        Class<RioServiceDescriptor> clazz = RioServiceDescriptor.class;
        synchronized (RioServiceDescriptor.class) {
            String policy;
            if (globalPolicy == null) {
                initialGlobalPolicy = Policy.getPolicy();
                globalPolicy = new AggregatePolicyProvider(initialGlobalPolicy);
                Policy.setPolicy(globalPolicy);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Global policy set: {0}", globalPolicy);
                }
            }
            if ((policy = this.getPolicy()) != null) {
                DynamicPolicyProvider service_policy = new DynamicPolicyProvider(new PolicyFileProvider(policy));
                LoaderSplitPolicyProvider splitServicePolicy = new LoaderSplitPolicyProvider(jsbCL, service_policy, new DynamicPolicyProvider(initialGlobalPolicy));
                splitServicePolicy.grant(RioServiceDescriptor.class, null, new Permission[]{new AllPermission()});
                globalPolicy.setPolicy(jsbCL, splitServicePolicy);
            }
            // ** MonitorExit[var12_13] (shouldn't be in output)
            try {
                Object impl = null;
                Class<?> implClass = null;
                String implClassName = this.getImplClassName();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Attempting to get implementation class name: " + implClassName);
                    logger.finest("jsbCL searchPath: " + Arrays.toString(jsbCL.getURLs()) + "  jsbCL: " + jsbCL);
                }
                implClass = Class.forName(implClassName, false, jsbCL);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Attempting to get implementation constructor");
                }
                Constructor<?> constructor = implClass.getDeclaredConstructor(actTypes);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Obtained implementation constructor: {0}", constructor);
                }
                constructor.setAccessible(true);
                impl = constructor.newInstance(this.getServerConfigArgs(), this.lifeCycle);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Obtained implementation instance: {0}", (Object)impl);
                }
                if ((proxy = impl instanceof ServiceProxyAccessor ? ((ServiceProxyAccessor)impl).getServiceProxy() : (impl instanceof ProxyAccessor ? ((ProxyAccessor)impl).getProxy() : null)) != null) {
                    proxy = servicePreparer.prepareProxy(proxy);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Proxy =  {0}", proxy);
                }
                currentThread.setContextClassLoader(currentClassLoader);
            }
            finally {
                currentThread.setContextClassLoader(currentClassLoader);
            }
            return proxy;
        }
    }

    public String toString() {
        ArrayList<Object> fields = new ArrayList<Object>(6);
        fields.add(this.codebase);
        fields.add(this.policy);
        fields.add(this.classpath);
        fields.add(this.implClassName);
        fields.add(Arrays.asList(this.serverConfigArgs));
        fields.add(this.lifeCycle);
        return fields.toString();
    }
}

