/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.classloader.CustomURLClassLoader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.loader.ClassAnnotation;
import org.jini.rio.boot.AdditionalClassProviderFactory;
import org.jini.rio.boot.ClassAnnotator;
import org.jini.rio.boot.CodeChangeClassLoadersManager;
import org.jini.rio.boot.SupportCodeChangeAnnotationContainer;

@InternalApi
public class ServiceClassLoader
extends CustomURLClassLoader
implements ClassAnnotation {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.lrmi.classloading");
    private URL[] searchPath;
    private List<URL> libPath;
    private URL slashPath;
    private final ClassAnnotator annotator;
    private boolean parentFirst = Boolean.parseBoolean(System.getProperty("com.gs.pu.classloader.parentFirst", "false"));
    private CodeChangeClassLoadersManager codeChangeClassLoadersManager;

    public ServiceClassLoader(String name, URL[] searchPath, ClassAnnotator annotator, ClassLoader parent) {
        super(name, searchPath, parent);
        if (annotator == null) {
            throw new NullPointerException("annotator is null");
        }
        this.annotator = annotator;
        this.searchPath = searchPath != null ? searchPath : new URL[]{};
    }

    public CodeChangeClassLoadersManager getCodeChangeClassLoadersManager() {
        return this.codeChangeClassLoadersManager;
    }

    public ClassAnnotator getClassAnnotator() {
        return this.annotator;
    }

    @Override
    public URL[] getURLs() {
        return this.annotator.getURLs();
    }

    public void setParentClassLoader(ClassLoader classLoader) throws Exception {
        Field field = ClassLoader.class.getDeclaredField("parent");
        field.setAccessible(true);
        field.set(this, classLoader);
    }

    @Override
    public synchronized URL[] getSearchPath() {
        return this.searchPath;
    }

    public synchronized void addURLs(List<URL> urls) {
        ArrayList<URL> searchList = new ArrayList<URL>();
        for (URL url : this.searchPath) {
            searchList.add(url);
        }
        for (URL url : urls) {
            super.addURL(url);
            searchList.add(url);
        }
        this.searchPath = searchList.toArray(new URL[searchList.size()]);
    }

    public synchronized void setLibPath(List<URL> urls) {
        this.addURLs(urls);
        this.libPath = urls;
    }

    public synchronized void setSlashPath(URL url) {
        this.addURLs(Collections.singletonList(url));
        this.slashPath = url;
    }

    public synchronized List<URL> getLibPath() {
        return this.libPath;
    }

    public synchronized URL getSlashPath() {
        return this.slashPath;
    }

    @Override
    public String getClassAnnotation() {
        return this.annotator.getClassAnnotation();
    }

    @Override
    public synchronized URL getResource(String name) {
        URL url = null;
        if (this.parentFirst && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        if (url != null) {
            return url;
        }
        url = this.findResource(name);
        if (url != null) {
            return url;
        }
        if (!this.parentFirst && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = ServiceClassLoader.getSystemClassLoader().loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.parentFirst && this.getParent() != null) {
            try {
                clazz = this.getParent().loadClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            clazz = AdditionalClassProviderFactory.loadClass(name, true);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!this.parentFirst && this.getParent() != null) {
            try {
                clazz = this.getParent().loadClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    public ClassLoader getCodeChangeClassLoader(SupportCodeChangeAnnotationContainer supportCodeChangeAnnotationContainer) {
        ClassLoader classLoader = this.codeChangeClassLoadersManager.getCodeChangeClassLoader(supportCodeChangeAnnotationContainer);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("In ServiceClassLoader[" + this + "], asked for class-loader with version [" + supportCodeChangeAnnotationContainer.getVersion() + "]  from CodeChangeClassLoadersManager [" + this.codeChangeClassLoadersManager + "]. Got class-loader [" + classLoader + " ]");
        }
        return classLoader;
    }

    public void initCodeChangeClassLoadersManager(boolean supportCodeChange, int maxClassLoaders) {
        this.codeChangeClassLoadersManager = new CodeChangeClassLoadersManager(this, supportCodeChange, maxClassLoaders);
    }
}

