/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.start.Locator;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.boot.CommonClassLoader;

@InternalApi
public class SharedServiceData {
    private static final Map<String, ClassLoader> jeeClassLoaders = new HashMap<String, ClassLoader>();
    private static final Map<String, ClassLoader> webAppClassLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private static final Map<String, List<Callable>> serviceDetails = new ConcurrentHashMap<String, List<Callable>>();
    private static final Map<String, List<Callable>> serviceMonitors = new ConcurrentHashMap<String, List<Callable>>();
    private static final Map<String, List<Callable<Boolean>>> memberAliveIndicators = new ConcurrentHashMap<String, List<Callable<Boolean>>>();
    private static final Map<String, List<Callable>> undeployingEventListeners = new ConcurrentHashMap<String, List<Callable>>();
    private static final Map<String, List<Object>> dumpProcessors = new ConcurrentHashMap<String, List<Object>>();

    private SharedServiceData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getJeeClassLoader(String jeeContainer, String ... classesToLoad) throws Exception {
        String gsLibOptional = Locator.getLibOptional();
        Map<String, ClassLoader> map = jeeClassLoaders;
        synchronized (map) {
            ClassLoader classLoader = jeeClassLoaders.get(jeeContainer);
            if (classLoader == null) {
                List<URL> urls = BootUtil.toURLs(gsLibOptional + jeeContainer);
                classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)CommonClassLoader.getInstance());
                ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    if (classesToLoad != null) {
                        for (String classToLoad : classesToLoad) {
                            classLoader.loadClass(classToLoad);
                        }
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(prevClassLoader);
                }
                jeeClassLoaders.put(jeeContainer, classLoader);
            }
            return classLoader;
        }
    }

    public static void putWebAppClassLoader(String key, ClassLoader webAppClassLoader) {
        webAppClassLoaders.put(key, webAppClassLoader);
    }

    public static ClassLoader removeWebAppClassLoader(String key) {
        return webAppClassLoaders.remove(key);
    }

    public static void addServiceDetails(String key, Callable provider) {
        List<Callable> list = serviceDetails.get(key);
        if (list == null) {
            list = new ArrayList<Callable>();
            serviceDetails.put(key, list);
        }
        list.add(provider);
    }

    public static List<Callable> removeServiceDetails(String key) {
        return serviceDetails.remove(key);
    }

    public static void addServiceMonitors(String key, Callable provider) {
        List<Callable> list = serviceMonitors.get(key);
        if (list == null) {
            list = new ArrayList<Callable>();
            serviceMonitors.put(key, list);
        }
        list.add(provider);
    }

    public static List<Callable> removeServiceMonitors(String key) {
        return serviceMonitors.remove(key);
    }

    public static void addMemberAliveIndicator(String key, Callable<Boolean> provider) {
        List<Callable<Boolean>> list = memberAliveIndicators.get(key);
        if (list == null) {
            list = new ArrayList<Callable<Boolean>>();
            memberAliveIndicators.put(key, list);
        }
        list.add(provider);
    }

    public static List<Callable<Boolean>> removeMemberAliveIndicator(String key) {
        return memberAliveIndicators.remove(key);
    }

    public static void addUndeployingEventListener(String key, Callable provider) {
        List<Callable> list = undeployingEventListeners.get(key);
        if (list == null) {
            list = new ArrayList<Callable>();
            undeployingEventListeners.put(key, list);
        }
        list.add(provider);
    }

    public static List<Callable> removeUndeployingEventListeners(String key) {
        return undeployingEventListeners.remove(key);
    }

    public static void addDumpProcessors(String key, Object provider) {
        List<Object> list = dumpProcessors.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            dumpProcessors.put(key, list);
        }
        list.add(provider);
    }

    public static List<Object> removeDumpProcessors(String key) {
        return dumpProcessors.remove(key);
    }
}

