/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.resource;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.resources.resource.ThreadPool;

public final class PoolableThread
extends Thread {
    protected static int nextThreadID = 0;
    protected final ThreadPool pool;
    final int threadID;
    private boolean keepAlive = true;
    protected Runnable runObj;
    private final Hashtable objectCache = new Hashtable();
    private final Object working = new Object();
    private final Object complete = new Object();
    private static final Logger logger = Logger.getLogger("org.jini.rio.resources.resource.PoolableThread");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolableThread(ThreadPool pool) {
        super(pool.getThreadGroup(), "");
        this.pool = pool;
        Class<PoolableThread> clazz = PoolableThread.class;
        synchronized (PoolableThread.class) {
            this.threadID = nextThreadID++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.setName(pool.getIdentifier() + "-" + this.threadID);
            return;
        }
    }

    public boolean isReady() {
        return this.runObj == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinResource() throws InterruptedException {
        if (this.runObj != null) {
            Object object = this.complete;
            synchronized (object) {
                if (this.runObj != null) {
                    this.complete.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (this.keepAlive) {
            Object object = this.working;
            synchronized (object) {
                if (this.runObj == null) {
                    try {
                        this.working.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (this.runObj != null) {
                        this.runObj.run();
                        this.runObj = null;
                    }
                    Object object2 = this.complete;
                    synchronized (object2) {
                        this.complete.notifyAll();
                    }
                }
                catch (Throwable t) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Running poolable thread id=" + this.threadID, t);
                    }
                }
                finally {
                    block24: {
                        try {
                            this.pool.release(this);
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.FINEST)) break block24;
                            logger.log(Level.FINEST, "Releasing poolable thread id=" + this.threadID, e);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) throws IllegalStateException {
        if (this.runObj != null) {
            throw new IllegalStateException("Cannot execute PoolableThread that is busy");
        }
        Object object = this.working;
        synchronized (object) {
            if (this.runObj != null) {
                throw new IllegalStateException("Cannot execute PoolableThread that is busy");
            }
            this.runObj = runnable;
            this.working.notifyAll();
        }
    }

    public void cleanStop() {
        this.keepAlive = false;
        this.interrupt();
    }

    public void stopExecution() {
        this.interrupt();
    }

    public int getID() {
        return this.threadID;
    }

    public Object getResource(Object key) {
        return this.objectCache.get(key);
    }

    public Object putResource(Object key, Object value) {
        return this.objectCache.put(key, value);
    }

    public void clearResources() {
        this.objectCache.clear();
    }
}

