/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.resource;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.resources.resource.ResourceUnavailableException;

public abstract class ResourcePool {
    static final Hashtable theInstances = new Hashtable();
    protected LinkedList freed = new LinkedList();
    protected LinkedList alloced = new LinkedList();
    protected int min;
    protected int max = Integer.MAX_VALUE;
    protected int numCreated;
    protected String identifier;
    static Logger logger = Logger.getLogger("org.jini.rio.resources.resource");

    protected abstract Object create() throws ResourceUnavailableException;

    protected abstract void dispose(Object var1);

    protected abstract boolean validate(Object var1);

    public synchronized void release(Object obj) {
        if (obj == null) {
            throw new NullPointerException("ResourcePool: managed resource cannot be null");
        }
        if (!this.alloced.remove(obj)) {
            throw new IllegalArgumentException("ResourcePool: unknown resource " + obj);
        }
        this.freeResource(obj);
        this.notifyAll();
    }

    public synchronized void remove(Object obj) {
        if (this.alloced.remove(obj) || this.freed.remove(obj)) {
            --this.numCreated;
        }
        this.disposeResource(obj);
    }

    public synchronized Object get() throws ResourceUnavailableException {
        return this.get(0L);
    }

    public synchronized Object get(long timeout) throws ResourceUnavailableException {
        while (true) {
            Object obj;
            if (this.numCreated >= this.max) {
                while (this.freed.size() == 0) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException ignore) {
                        logger.warning("Getting a resource has been interrupted");
                    }
                    if (timeout <= 0L) continue;
                }
            }
            if (this.freed.size() == 0) {
                if (this.numCreated >= this.max) {
                    throw new ResourceUnavailableException("Resource: " + this.getClass().getName() + " is not available after " + timeout + " milliseconds");
                }
                this.createResource();
            }
            if ((obj = this.freed.removeFirst()) == null) {
                throw new ResourceUnavailableException("Resource: " + this.getClass().getName() + "is corrupted");
            }
            if (this.validate(obj)) {
                this.allocResource(obj);
                return obj;
            }
            try {
                --this.numCreated;
                this.disposeResource(obj);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Disposing a resource", e);
                continue;
            }
            break;
        }
    }

    protected Object createResource() throws ResourceUnavailableException {
        Object resource = this.create();
        this.freed.add(resource);
        ++this.numCreated;
        return resource;
    }

    protected void allocResource(Object resource) {
        this.alloced.add(resource);
    }

    protected void freeResource(Object resource) {
        this.freed.add(resource);
    }

    protected void disposeResource(Object resource) {
        this.dispose(resource);
    }

    public synchronized int getFreedSize() {
        return this.freed.size();
    }

    public synchronized int getAllocedSize() {
        return this.alloced.size();
    }

    public synchronized <T> List<T> getAllocedOfType(Class<T> type) {
        ArrayList ret = new ArrayList();
        for (Object obj : this.alloced) {
            if (!type.isInstance(type)) continue;
            ret.add(obj);
        }
        return ret;
    }

    public synchronized int getSize() {
        return this.numCreated;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public synchronized void setMin(int min) {
        if (min < 0 || min > this.max) {
            throw new IllegalArgumentException("ResourcePool: min > max resources");
        }
        this.min = min;
    }

    public void setIdentifier(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected void createResources() throws ResourceUnavailableException {
        this.createResources(this.min);
    }

    protected void createResources(int number) throws ResourceUnavailableException {
        while (this.numCreated < number) {
            this.createResource();
        }
    }

    public synchronized void setMax(int max) {
        if (max < this.min) {
            throw new IllegalArgumentException("ResourcePool: min > max resources");
        }
        this.max = max;
    }

    public static ResourcePool getInstance(String key) {
        return (ResourcePool)theInstances.get(key);
    }

    protected void register() {
        ResourcePool.register(this.identifier, this);
    }

    protected void register(String key) {
        ResourcePool.register(key, this);
    }

    public static void register(String key, ResourcePool pool) {
        theInstances.put(key, pool);
    }

    public String toString() {
        return this.identifier + ":min=" + this.getMin() + ":max=" + this.getMax() + ":create=" + this.getSize() + ":free=" + this.getFreedSize() + ":asgn=" + this.getAllocedSize() + ":audit=" + (this.getSize() - (this.getAllocedSize() + this.getFreedSize()));
    }
}

